/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractEntityHistoryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IRelatedEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelatedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelatedExperiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelatedProject;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelatedSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelatedSpace;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePropertyTypePE;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="sample_history_view")
public class SampleHistoryPE
extends AbstractEntityHistoryPE {
    private static final long serialVersionUID = 35L;
    private Long sampleId;
    private Long dataSetId;
    private Long spaceId;
    private Long experimentId;
    private Long projectId;

    @ManyToOne(fetch=FetchType.LAZY, targetEntity=SamplePE.class)
    @JoinColumn(name="main_samp_id")
    SamplePE getEntityInternal() {
        return (SamplePE)this.entity;
    }

    private void setEntityInternal(SamplePE sample) {
        this.entity = sample;
    }

    @ManyToOne(fetch=FetchType.EAGER, targetEntity=SampleTypePropertyTypePE.class)
    @JoinColumn(name="stpt_id")
    public EntityTypePropertyTypePE getEntityTypePropertyTypeInternal() {
        return this.entityTypePropertyType;
    }

    private void setEntityTypePropertyTypeInternal(SampleTypePropertyTypePE sampleTypePropertyType) {
        this.entityTypePropertyType = sampleTypePropertyType;
    }

    @Column(name="samp_id")
    public Long getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(Long sampleId) {
        this.sampleId = sampleId;
    }

    @Column(name="data_id")
    public Long getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(Long dataSetId) {
        this.dataSetId = dataSetId;
    }

    @Column(name="space_id")
    public Long getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(Long spaceId) {
        this.spaceId = spaceId;
    }

    @Column(name="expe_id")
    public Long getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(Long experimentId) {
        this.experimentId = experimentId;
    }

    @Column(name="proj_id")
    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    @Transient
    public IRelatedEntity getRelatedEntity() {
        if (this.sampleId != null) {
            return new RelatedSample(this.sampleId);
        }
        if (this.dataSetId != null) {
            return new RelatedDataSet(this.dataSetId);
        }
        if (this.spaceId != null) {
            return new RelatedSpace(this.spaceId);
        }
        if (this.experimentId != null) {
            return new RelatedExperiment(this.experimentId);
        }
        if (this.projectId != null) {
            return new RelatedProject(this.projectId);
        }
        return null;
    }
}

