/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyWithSampleDataTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePropertyTypePE;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="sample_properties", uniqueConstraints={@UniqueConstraint(columnNames={"samp_id", "stpt_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class SamplePropertyPE
extends EntityPropertyWithSampleDataTypePE {
    private static final long serialVersionUID = 35L;
    public static final SamplePropertyPE[] EMPTY_ARRAY = new SamplePropertyPE[0];

    @Override
    @NotNull(message="Sample type can not be null.")
    @ManyToOne(fetch=FetchType.EAGER, targetEntity=SampleTypePropertyTypePE.class)
    @JoinColumn(name="stpt_id")
    public EntityTypePropertyTypePE getEntityTypePropertyType() {
        return this.entityTypePropertyType;
    }

    @Override
    @SequenceGenerator(name="SAMPLE_PROPERTY_ID_SEQ", sequenceName="SAMPLE_PROPERTY_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SAMPLE_PROPERTY_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    @Override
    @NotNull(message="Sample can not be null.")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="samp_id")
    public SamplePE getEntity() {
        return (SamplePE)this.entity;
    }

    @Override
    @NotNull
    @Column(name="samp_frozen", nullable=false)
    public boolean isEntityFrozen() {
        return this.entityFrozen;
    }
}

