/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.hibernate.JsonMapUserType;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.type.DbTimestampType;

@Entity
@Table(name="sample_relationships", uniqueConstraints={@UniqueConstraint(columnNames={"sample_id_parent", "sample_id_child", "relationship_id"})})
@TypeDefs(value={@TypeDef(name="transactiontimestamp", typeClass=DbTimestampType.class), @TypeDef(name="JsonMap", typeClass=JsonMapUserType.class)})
public class SampleRelationshipPE
implements Serializable {
    private static final long serialVersionUID = 35L;
    protected transient Long id;
    private SamplePE parentSample;
    private Map<String, String> parentAnnotations;
    private boolean parentFrozen;
    private SamplePE childSample;
    private Map<String, String> childAnnotations;
    private boolean childFrozen;
    private PersonPE author;
    private Date registrationDate;
    private Date modificationDate;
    private RelationshipTypePE relationship;
    private DeletionPE deletion;

    @Deprecated
    public SampleRelationshipPE() {
    }

    public SampleRelationshipPE(SamplePE parentSample, SamplePE childSample, RelationshipTypePE relationship, PersonPE author) {
        this.setParentSample(parentSample);
        this.setChildSample(childSample);
        this.relationship = relationship;
        this.author = author;
        parentSample.addChildRelationship(this);
        childSample.addParentRelationship(this);
    }

    @NotNull(message="Parent can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="sample_id_parent")
    public SamplePE getParentSample() {
        return this.parentSample;
    }

    public void setParentSample(SamplePE parentSample) {
        this.parentSample = parentSample;
        if (parentSample != null) {
            this.parentFrozen = parentSample.isFrozen() && parentSample.isFrozenForChildren();
        }
    }

    @Column(name="parent_annotations")
    @Type(type="JsonMap")
    public Map<String, String> getParentAnnotations() {
        return this.parentAnnotations;
    }

    public void setParentAnnotations(Map<String, String> parentAnnotations) {
        this.parentAnnotations = parentAnnotations;
    }

    @NotNull
    @Column(name="parent_frozen", nullable=false)
    public boolean isParentFrozen() {
        if (this.parentSample != null) {
            this.parentFrozen = this.parentSample.isFrozen() && this.parentSample.isFrozenForChildren();
        }
        return this.parentFrozen;
    }

    public void setParentFrozen(boolean parentFrozen) {
        this.parentFrozen = parentFrozen;
    }

    @NotNull(message="Child can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="sample_id_child")
    public SamplePE getChildSample() {
        return this.childSample;
    }

    public void setChildSample(SamplePE childSample) {
        this.childSample = childSample;
        if (childSample != null) {
            this.childFrozen = childSample.isFrozen() && childSample.isFrozenForParents();
        }
    }

    @Column(name="child_annotations")
    @Type(type="JsonMap")
    public Map<String, String> getChildAnnotations() {
        return this.childAnnotations;
    }

    public void setChildAnnotations(Map<String, String> childAnnotations) {
        this.childAnnotations = childAnnotations;
    }

    @NotNull
    @Column(name="child_frozen", nullable=false)
    public boolean isChildFrozen() {
        if (this.childSample != null) {
            this.childFrozen = this.childSample.isFrozen() && this.childSample.isFrozenForParents();
        }
        return this.childFrozen;
    }

    public void setChildFrozen(boolean childFrozen) {
        this.childFrozen = childFrozen;
    }

    @NotNull(message="Relationship can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="relationship_id")
    public RelationshipTypePE getRelationship() {
        return this.relationship;
    }

    public void setRelationship(RelationshipTypePE relationship) {
        this.relationship = relationship;
    }

    @SequenceGenerator(name="SAMPLE_RELATIONSHIP_ID_SEQ", sequenceName="SAMPLE_RELATIONSHIP_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SAMPLE_RELATIONSHIP_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pers_id_author")
    public PersonPE getAuthor() {
        return this.author;
    }

    public void setAuthor(PersonPE author) {
        this.author = author;
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    @Type(type="transactiontimestamp")
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }
}

