/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.builders;

import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMetaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSpace;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyUpdatesDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AtomicEntityOperationDetailsBuilder {
    private final List<ExperimentUpdatesDTO> experimentUpdates = new ArrayList<ExperimentUpdatesDTO>();
    private final List<NewSpace> spaceRegistrations = new ArrayList<NewSpace>();
    private final List<NewProject> projectRegistrations = new ArrayList<NewProject>();
    private final List<ProjectUpdatesDTO> projectUpdates = new ArrayList<ProjectUpdatesDTO>();
    private final List<NewExperiment> experimentRegistrations = new ArrayList<NewExperiment>();
    private final List<SampleUpdatesDTO> sampleUpdates = new ArrayList<SampleUpdatesDTO>();
    private final List<NewSample> sampleRegistrations = new ArrayList<NewSample>();
    private final Map<String, List<NewMaterial>> materialRegistrations = new HashMap<String, List<NewMaterial>>();
    private final List<MaterialUpdateDTO> materialUpdates = new ArrayList<MaterialUpdateDTO>();
    private final List<NewExternalData> dataSetRegistrations = new ArrayList<NewExternalData>();
    private final List<DataSetBatchUpdatesDTO> dataSetUpdates = new ArrayList<DataSetBatchUpdatesDTO>();
    private final List<NewMetaproject> metaprojectRegistrations = new ArrayList<NewMetaproject>();
    private final List<MetaprojectUpdatesDTO> metaprojectUpdates = new ArrayList<MetaprojectUpdatesDTO>();
    private final List<VocabularyUpdatesDTO> vocabularyUpdates = new ArrayList<VocabularyUpdatesDTO>();
    private TechId registrationIdOrNull;
    private String userIdOrNull;
    private Integer batchSizeOrNull;

    public AtomicEntityOperationDetailsBuilder user(String userId) {
        this.userIdOrNull = userId;
        return this;
    }

    public AtomicEntityOperationDetailsBuilder batchSize(int size) {
        this.batchSizeOrNull = size;
        return this;
    }

    public AtomicEntityOperationDetailsBuilder project(NewProject newProject) {
        this.projectRegistrations.add(newProject);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder projectUpdate(ProjectUpdatesDTO projectUpdate) {
        this.projectUpdates.add(projectUpdate);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder experiment(NewExperiment newExperiment) {
        this.experimentRegistrations.add(newExperiment);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder experimentUpdate(ExperimentUpdatesDTO experimentUpdate) {
        this.experimentUpdates.add(experimentUpdate);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder sample(NewSample newSample) {
        this.sampleRegistrations.add(newSample);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder sampleUpdate(SampleUpdatesDTO sampleUpdate) {
        this.sampleUpdates.add(sampleUpdate);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder dataSet(NewExternalData newDataSet) {
        this.dataSetRegistrations.add(newDataSet);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder dataSetUpdate(DataSetBatchUpdatesDTO dataSetUpdate) {
        this.dataSetUpdates.add(dataSetUpdate);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder metaProject(NewMetaproject metaProject) {
        this.metaprojectRegistrations.add(metaProject);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder materialUpdate(MaterialUpdateDTO materialUpdate) {
        this.materialUpdates.add(materialUpdate);
        return this;
    }

    public AtomicEntityOperationDetailsBuilder metaProjectUpdate(MetaprojectUpdatesDTO metaProjectUpdate) {
        this.metaprojectUpdates.add(metaProjectUpdate);
        return this;
    }

    public AtomicEntityOperationDetails getDetails() {
        return new AtomicEntityOperationDetails(this.registrationIdOrNull, this.userIdOrNull, this.spaceRegistrations, this.projectRegistrations, this.projectUpdates, this.experimentRegistrations, this.experimentUpdates, this.sampleUpdates, this.sampleRegistrations, this.materialRegistrations, this.materialUpdates, this.dataSetRegistrations, this.dataSetUpdates, this.metaprojectRegistrations, this.metaprojectUpdates, this.vocabularyUpdates, this.batchSizeOrNull);
    }

    public AtomicEntityOperationDetailsBuilder material(NewMaterialWithType newMaterial) {
        String type = newMaterial.getType();
        List<NewMaterial> list = this.materialRegistrations.get(type);
        if (list == null) {
            list = new ArrayList<NewMaterial>();
            this.materialRegistrations.put(type, list);
        }
        list.add(newMaterial.getMaterial());
        return this;
    }

    public AtomicEntityOperationDetailsBuilder space(NewSpace newSpace) {
        this.spaceRegistrations.add(newSpace);
        return this;
    }
}

