/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.hibernate;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class JsonMapUserType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2000};
    }

    public Class<Map> returnedClass() {
        return Map.class;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String cellContent = rs.getString(names[0]);
        if (cellContent == null) {
            return null;
        }
        try {
            return new ObjectMapper().readValue(cellContent.getBytes("UTF-8"), HashMap.class);
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 1111);
            return;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter w = new StringWriter();
            mapper.writeValue((Writer)w, value);
            w.flush();
            st.setObject(index, (Object)w.toString(), 1111);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == null ? x == y : x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public Object deepCopy(Object object) throws HibernateException {
        if (!(object instanceof Map)) {
            return object;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : ((Map)object).entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) {
                return object;
            }
            Object value = entry.getValue();
            if (!(value instanceof String)) {
                return object;
            }
            result.put((String)key, (String)value);
        }
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

