/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedSamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class IdentifierHelper {
    private IdentifierHelper() {
    }

    public static final SpaceIdentifier createGroupIdentifier(SpacePE groupPE) {
        assert (groupPE != null) : "Unspecified space";
        return new SpaceIdentifier(groupPE.getCode());
    }

    public static final SampleIdentifier createSampleIdentifier(SamplePE samplePE) {
        assert (samplePE != null) : "Unspecified sample";
        ProjectPE project = samplePE.getProject();
        SpacePE space = samplePE.getSpace();
        String sampleCode = IdentifierHelper.extractCode(samplePE);
        return IdentifierHelper.createSampleIdentifier(project, space, sampleCode);
    }

    public static final SampleIdentifier sample(SamplePE sample) {
        SampleIdentifier sampleId = sample.getSpace() == null ? new SampleIdentifier(sample.getCode()) : new SampleIdentifier(new SpaceIdentifier(sample.getSpace().getCode()), sample.getCode());
        if (sample.getContainer() != null) {
            sampleId.addContainerCode(sample.getContainer().getCode());
        }
        return sampleId;
    }

    public static final SpaceIdentifier space(SpacePE space) {
        return new SpaceIdentifier(space.getCode());
    }

    public static final SampleIdentifier createSampleIdentifier(DeletedSamplePE deletedSamplePE) {
        assert (deletedSamplePE != null) : "Unspecified sample";
        ProjectPE project = deletedSamplePE.getProject();
        SpacePE space = deletedSamplePE.getSpace();
        String sampleCode = deletedSamplePE.getCode();
        return IdentifierHelper.createSampleIdentifier(project, space, sampleCode);
    }

    public static final SampleIdentifier createSampleIdentifier(SpaceIdentifier spaceIdentifier, String sampleCode, String sampleContainerCode) {
        String fullSampleCode = IdentifierHelper.convertCode(sampleCode, sampleContainerCode);
        if (spaceIdentifier == null) {
            return new SampleIdentifier(fullSampleCode);
        }
        return new SampleIdentifier(spaceIdentifier, fullSampleCode);
    }

    private static SampleIdentifier createSampleIdentifier(ProjectPE project, SpacePE space, String sampleCode) {
        if (space == null) {
            return new SampleIdentifier(sampleCode);
        }
        if (project != null) {
            SpaceIdentifier spaceIdentifier = IdentifierHelper.createGroupIdentifier(project.getSpace());
            ProjectIdentifier projectIdentifier = new ProjectIdentifier(spaceIdentifier, project.getCode());
            return new SampleIdentifier(projectIdentifier, sampleCode);
        }
        return new SampleIdentifier(IdentifierHelper.createGroupIdentifier(space), sampleCode);
    }

    public static SampleIdentifier createSampleIdentifier(Sample sample) {
        assert (sample != null) : "Unspecified sample";
        Project project = sample.getProject();
        String sampleCode = sample.getCode();
        if (project != null) {
            Space space = project.getSpace();
            if (space == null) {
                throw new IllegalArgumentException("Missing space code of project sample " + sample);
            }
            return new SampleIdentifier(new ProjectIdentifier(space.getCode(), project.getCode()), sampleCode);
        }
        Space space = sample.getSpace();
        if (space != null) {
            return new SampleIdentifier(new SpaceIdentifier(space.getCode()), sampleCode);
        }
        return new SampleIdentifier(sampleCode);
    }

    public static final String extractSubCode(SamplePE samplePE) {
        return samplePE.getCode();
    }

    public static final String convertSubCode(String sampleCode) {
        return sampleCode;
    }

    public static final String extractCode(SamplePE samplePE) {
        String code;
        String subCode = IdentifierHelper.extractSubCode(samplePE);
        if (samplePE.getContainer() != null && HibernateUtils.isInitialized(samplePE.getContainer())) {
            String containerCode = samplePE.getContainer().getCode();
            code = containerCode + ":" + subCode;
        } else {
            code = subCode;
        }
        return code;
    }

    public static final String convertCode(String sampleCode, String containerCodeOrNull) {
        String code;
        String subCode = IdentifierHelper.convertSubCode(sampleCode);
        if (containerCodeOrNull != null) {
            String containerCode = containerCodeOrNull;
            code = containerCode + ":" + subCode;
        } else {
            code = subCode;
        }
        return code;
    }

    public static final ProjectIdentifier createProjectIdentifier(ProjectPE project) {
        assert (project != null) : "Unspecified project";
        SpacePE group = project.getSpace();
        ProjectIdentifier identifier = new ProjectIdentifier(group.getCode(), project.getCode());
        return identifier;
    }

    public static final ProjectIdentifier createFullProjectIdentifier(ProjectPE project) {
        assert (project != null) : "Unspecified project";
        return new ProjectIdentifier(project.getSpace().getCode(), project.getCode());
    }

    public static final ProjectIdentifier createFullProjectIdentifier(ProjectIdentifier projectIdentifier) {
        assert (projectIdentifier != null) : "Unspecified project identifier";
        return new ProjectIdentifier(projectIdentifier.getSpaceCode(), projectIdentifier.getProjectCode());
    }

    public static final ExperimentIdentifier createExperimentIdentifier(ExperimentPE experiment) {
        assert (experiment != null) : "Unspecified experiment";
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(IdentifierHelper.createProjectIdentifier(experiment.getProject()), experiment.getCode());
        return experimentIdentifier;
    }

    public static final List<SampleIdentifier> extractSampleIdentifiers(NewExperiment newExperiment) {
        ArrayList<SampleIdentifier> result = new ArrayList<SampleIdentifier>();
        for (NewSamplesWithTypes samplesWithTypes : newExperiment.getNewSamples()) {
            for (NewSample sample : samplesWithTypes.getNewEntities()) {
                SampleIdentifier identifier = SampleIdentifierFactory.parse(sample);
                if (identifier.tryGetContainerCode() == null && !StringUtils.isEmpty((CharSequence)sample.getContainerIdentifier())) {
                    SampleIdentifier containerIdentifier = SampleIdentifierFactory.parse(sample.getContainerIdentifier());
                    identifier.addContainerCode(containerIdentifier.getSampleCode());
                }
                result.add(identifier);
            }
        }
        return result;
    }

    public static final List<SampleIdentifier> extractSampleIdentifiers(String[] samples, String defaultSpace) {
        ArrayList<SampleIdentifier> sampleIdentifiers = new ArrayList<SampleIdentifier>();
        for (String s : samples) {
            sampleIdentifiers.add(SampleIdentifierFactory.parse(s, defaultSpace));
        }
        return sampleIdentifiers;
    }

    public static void fillAndCheckGroup(SampleIdentifier sample, String expectedGroupCode) {
        if (sample.isDatabaseInstanceLevel()) {
            return;
        }
        if (!sample.isInsideHomeSpace()) {
            if (sample.getSpaceLevel().getSpaceCode().equalsIgnoreCase(expectedGroupCode)) {
                return;
            }
            throw new UserFailureException(String.format("Sample '%s' does not belong to the space '%s'", sample, expectedGroupCode));
        }
        sample.getSpaceLevel().setSpaceCode(expectedGroupCode);
    }

    public static void fillSpaceIfNotSpecified(SampleIdentifier sample, String defaultSpaceCode) {
        if (sample.isInsideHomeSpace()) {
            sample.getSpaceLevel().setSpaceCode(defaultSpaceCode);
        }
    }
}

