/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import java.io.Serializable;

public class LocalExperimentIdentifier
implements Serializable {
    private static final long serialVersionUID = 35L;
    private final String projectCode;
    private String propertyCodeOrNull;
    private String propertyValue;
    private String experimentCode;

    public LocalExperimentIdentifier(String projectCode, String propertyCode, String propertyValue) {
        this.projectCode = projectCode;
        this.propertyCodeOrNull = propertyCode;
        this.propertyValue = propertyValue;
        this.experimentCode = null;
    }

    public LocalExperimentIdentifier(String projectCode, String experimentCode) {
        this.projectCode = projectCode;
        this.propertyCodeOrNull = null;
        this.propertyValue = null;
        this.experimentCode = experimentCode;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public String tryGetPropertyCode() {
        return this.propertyCodeOrNull;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public String getExperimentCode() {
        return this.experimentCode;
    }

    public String toString() {
        String expDesc = this.propertyCodeOrNull != null ? this.propertyCodeOrNull + " = '" + this.propertyValue + "'" : this.experimentCode;
        return "project '" + this.projectCode + "', experiment " + expDesc;
    }
}

