/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

public class SampleIdentifier
extends SampleOwnerIdentifier {
    private static final long serialVersionUID = 35L;
    public static final String CONTAINED_SAMPLE_CODE_SEPARARTOR_STRING = ":";
    public static final SampleIdentifier[] EMPTY_ARRAY = new SampleIdentifier[0];
    private String sampleCode;
    private String sampleSubCode;
    private String containerCodeOrNull;

    public SampleIdentifier(ProjectIdentifier projectIdentifier, String sampleCode) {
        super(projectIdentifier);
        this.setSampleCode(sampleCode);
    }

    public SampleIdentifier(SpaceIdentifier spaceIdentOrNull, String sampleCode) {
        super(spaceIdentOrNull);
        this.setSampleCode(sampleCode);
    }

    public static SampleIdentifier createOwnedBy(SampleOwnerIdentifier owner, String sampleCode) {
        if (owner.isDatabaseInstanceLevel()) {
            return new SampleIdentifier(sampleCode);
        }
        if (owner.isSpaceLevel()) {
            return new SampleIdentifier(owner.getSpaceLevel(), sampleCode);
        }
        return new SampleIdentifier(owner.getProjectLevel(), sampleCode);
    }

    public SampleIdentifier(String sampleCode) {
        this.setSampleCode(sampleCode);
    }

    public static SampleIdentifier create(String spaceCode, String sampleCode) {
        return new SampleIdentifier(new SpaceIdentifier(spaceCode), sampleCode);
    }

    public static SampleIdentifier createHomeGroup(String sampleCode) {
        return new SampleIdentifier(SpaceIdentifier.createHome(), sampleCode);
    }

    public String getSampleCode() {
        return this.sampleCode;
    }

    public String getSampleSubCode() {
        return this.sampleSubCode;
    }

    public String tryGetContainerCode() {
        return this.containerCodeOrNull;
    }

    public SampleOwnerIdentifier createSampleOwnerIdentifier() {
        if (this.getProjectLevel() != null) {
            return new SampleOwnerIdentifier(this.getProjectLevel());
        }
        if (this.getSpaceLevel() != null) {
            return new SampleOwnerIdentifier(this.getSpaceLevel());
        }
        return new SampleOwnerIdentifier();
    }

    @Override
    public String toString() {
        return super.toString() + this.sampleCode;
    }

    @Deprecated
    public void setSampleCode(String sampleCode) {
        this.sampleCode = sampleCode;
        if (sampleCode != null) {
            String[] sampleCodeTokens = sampleCode.split(CONTAINED_SAMPLE_CODE_SEPARARTOR_STRING);
            this.sampleSubCode = sampleCodeTokens[sampleCodeTokens.length - 1];
            if (sampleCodeTokens.length > 1) {
                this.containerCodeOrNull = sampleCodeTokens[0];
            }
        } else {
            this.sampleSubCode = null;
        }
    }

    public void addContainerCode(String containerCode) {
        assert (containerCode != null);
        assert (!containerCode.contains(CONTAINED_SAMPLE_CODE_SEPARARTOR_STRING));
        assert (this.sampleSubCode.equals(this.sampleCode));
        this.setSampleCode(containerCode + CONTAINED_SAMPLE_CODE_SEPARARTOR_STRING + this.sampleSubCode);
    }

    @Deprecated
    public SampleIdentifier() {
    }

    @Override
    public final int compareTo(SampleOwnerIdentifier o) {
        int ownerCmp = super.compareTo(o);
        if (ownerCmp == 0) {
            return this.sampleCode.compareTo(((SampleIdentifier)o).sampleCode);
        }
        return ownerCmp;
    }
}

