/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.Serializable;

public class SampleOwnerIdentifier
extends AbstractHashable
implements Serializable,
Comparable<SampleOwnerIdentifier> {
    private static final long serialVersionUID = 35L;
    private SpaceIdentifier spaceIdentOrNull;
    private ProjectIdentifier projectIdentifier;

    public SampleOwnerIdentifier() {
    }

    public SampleOwnerIdentifier(SpaceIdentifier identifier) {
        assert (identifier != null) : "space identifier cannot be null";
        this.spaceIdentOrNull = identifier;
    }

    public SampleOwnerIdentifier(ProjectIdentifier identifier) {
        assert (identifier != null) : "project identifier cannot be null";
        this.projectIdentifier = identifier;
    }

    public boolean isInsideHomeSpace() {
        return this.isSpaceLevel() && this.spaceIdentOrNull.isHomeSpace();
    }

    public boolean isProjectLevel() {
        return this.projectIdentifier != null;
    }

    public boolean isSpaceLevel() {
        return this.projectIdentifier == null && this.spaceIdentOrNull != null;
    }

    public boolean isDatabaseInstanceLevel() {
        return this.projectIdentifier == null && this.spaceIdentOrNull == null;
    }

    @Override
    public String toString() {
        if (this.isProjectLevel()) {
            return this.projectIdentifier.asProjectIdentifierString() + '/';
        }
        if (this.isSpaceLevel()) {
            if (this.isInsideHomeSpace()) {
                return "";
            }
            return this.spaceIdentOrNull.toString() + '/';
        }
        if (this.isDatabaseInstanceLevel()) {
            return "/";
        }
        throw new IllegalStateException("sample owner is unknown");
    }

    public ProjectIdentifier getProjectLevel() {
        return this.projectIdentifier;
    }

    public SpaceIdentifier getSpaceLevel() {
        return this.projectIdentifier != null ? this.projectIdentifier : this.spaceIdentOrNull;
    }

    @Override
    public int compareTo(SampleOwnerIdentifier other) {
        if (this.isProjectLevel()) {
            if (other.isProjectLevel()) {
                return this.getProjectLevel().toString().compareTo(other.getProjectLevel().toString());
            }
            return 1;
        }
        if (this.isSpaceLevel()) {
            if (other.isProjectLevel()) {
                return -1;
            }
            if (other.isSpaceLevel()) {
                return this.getSpaceLevel().compareTo(other.getSpaceLevel());
            }
            return 1;
        }
        if (this.isDatabaseInstanceLevel()) {
            if (other.isProjectLevel() || other.isSpaceLevel()) {
                return -1;
            }
            return 0;
        }
        throw new IllegalStateException("sample owner is unknown");
    }
}

