/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.parser;

import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedSample;
import ch.systemsx.cisd.openbis.generic.shared.parser.NewSampleParserObjectFactory;
import java.util.ArrayList;
import java.util.HashSet;

final class UpdatedSampleParserObjectFactory
extends NewSampleParserObjectFactory {
    private final SampleBatchUpdateDetails basicBatchUpdateDetails = this.createBasicBatchUpdateDetails();

    UpdatedSampleParserObjectFactory(SampleType sampleType, IPropertyMapper propertyMapper, boolean identifierExpectedInFile, boolean allowExperiments) {
        super(sampleType, propertyMapper, identifierExpectedInFile, allowExperiments);
    }

    private SampleBatchUpdateDetails createBasicBatchUpdateDetails() {
        boolean updateExperiment = this.isColumnAvailable("experiment");
        boolean updateParent = this.isColumnAvailable("parent");
        boolean updateParents = this.isColumnAvailable("parents");
        if (updateParent && updateParents) {
            throw new ParserException("Both 'parent' and 'parents' columns were specified. One of them should be removed from the file.");
        }
        boolean updateContainer = this.isColumnAvailable("container");
        return new SampleBatchUpdateDetails(updateExperiment, updateParents |= updateParent, updateContainer, this.getUnmatchedProperties());
    }

    @Override
    public NewSample createObject(String[] lineTokens) throws ParserException {
        NewSample newSample = super.createObject(lineTokens);
        SampleBatchUpdateDetails updateDetails = this.createBatchUpdateDetails(newSample);
        this.cleanUp(newSample);
        return new UpdatedSample(newSample, updateDetails);
    }

    private SampleBatchUpdateDetails createBatchUpdateDetails(NewSample newSample) {
        boolean updateExperiment = this.basicBatchUpdateDetails.isExperimentUpdateRequested() && UpdatedSampleParserObjectFactory.isNotEmpty(newSample.getExperimentIdentifier());
        boolean updateParents = this.basicBatchUpdateDetails.isParentsUpdateRequested() && UpdatedSampleParserObjectFactory.isNotEmpty(newSample.getParentsOrNull());
        boolean updateContainer = this.basicBatchUpdateDetails.isContainerUpdateRequested() && UpdatedSampleParserObjectFactory.isNotEmpty(newSample.getContainerIdentifier());
        HashSet<String> propertiesToUpdate = new HashSet<String>();
        for (IEntityProperty property : newSample.getProperties()) {
            propertiesToUpdate.add(property.getPropertyType().getCode());
        }
        return new SampleBatchUpdateDetails(updateExperiment, updateParents, updateContainer, propertiesToUpdate);
    }

    private void cleanUp(NewSample newSample) {
        if (UpdatedSampleParserObjectFactory.isDeletionMark(newSample.getExperimentIdentifier())) {
            newSample.setExperimentIdentifier(null);
        }
        if (UpdatedSampleParserObjectFactory.isDeletionMark(newSample.getParentsOrNull())) {
            newSample.setParentsOrNull(new String[0]);
        }
        if (UpdatedSampleParserObjectFactory.isDeletionMark(newSample.getContainerIdentifier())) {
            newSample.setContainerIdentifier(null);
        }
        ArrayList<IEntityProperty> updatedProperties = new ArrayList<IEntityProperty>();
        for (IEntityProperty property : newSample.getProperties()) {
            if (UpdatedSampleParserObjectFactory.isDeletionMark(property.getValue())) continue;
            updatedProperties.add(property);
        }
        newSample.setProperties(updatedProperties.toArray(IEntityProperty.EMPTY_ARRAY));
    }
}

