/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypeTranslator;
import java.util.HashMap;

public class DeletedEntityTranslator {
    public static IEntityInformationHolderWithIdentifier translate(IDeletablePE deletedEntity) {
        Long id = deletedEntity.getId();
        String code = deletedEntity.getCode();
        String permId = deletedEntity.getPermId();
        String identifier = deletedEntity.getIdentifier();
        EntityKind entityKind = EntityKind.valueOf(deletedEntity.getEntityKind().name());
        BasicEntityType entityType = DeletedEntityTranslator.translateType(entityKind, deletedEntity.getEntityType());
        return new DeletedEntity(id, code, permId, identifier, entityType, entityKind);
    }

    private static BasicEntityType translateType(EntityKind entityKind, EntityTypePE entityType) {
        HashMap<MaterialTypePE, MaterialType> materialTypeCache = new HashMap<MaterialTypePE, MaterialType>();
        HashMap<PropertyTypePE, PropertyType> propertyMap = new HashMap<PropertyTypePE, PropertyType>();
        switch (entityKind) {
            case EXPERIMENT: {
                return ExperimentTranslator.translate((ExperimentTypePE)entityType, materialTypeCache, propertyMap);
            }
            case SAMPLE: {
                return SampleTypeTranslator.translate((SampleTypePE)entityType, materialTypeCache, propertyMap);
            }
            case DATA_SET: {
                return DataSetTypeTranslator.translate((DataSetTypePE)entityType, materialTypeCache, propertyMap);
            }
        }
        throw new IllegalArgumentException("Invalid deleted entity" + entityKind);
    }
}

