/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyWithSampleDataTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PropertyTranslatorUtils;
import ch.systemsx.cisd.openbis.generic.shared.translator.PropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTermTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EntityPropertyTranslator {
    private EntityPropertyTranslator() {
    }

    public static final IEntityProperty translate(EntityPropertyPE propertyPE, Map<MaterialTypePE, MaterialType> materialTypeCache, Map<PropertyTypePE, PropertyType> cacheOrNull, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator) {
        return EntityPropertyTranslator.translate(propertyPE, materialTypeCache, cacheOrNull, false, managedPropertyEvaluatorFactory, samplePropertyAccessValidator);
    }

    public static final IEntityProperty translate(EntityPropertyPE propertyPE, Map<MaterialTypePE, MaterialType> materialTypeCache, Map<PropertyTypePE, PropertyType> cacheOrNull, boolean rawManagedProperties, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator) {
        IEntityProperty result;
        IEntityProperty basicProperty = PropertyTranslatorUtils.createEntityProperty(propertyPE);
        PropertyType propertyType = PropertyTypeTranslator.translate(propertyPE.getEntityTypePropertyType().getPropertyType(), materialTypeCache, cacheOrNull);
        Long ordinal = propertyPE.getEntityTypePropertyType().getOrdinal();
        PropertyTranslatorUtils.initializeEntityProperty(basicProperty, propertyType, ordinal);
        DataTypeCode typeCode = PropertyTranslatorUtils.getDataTypeCode(propertyPE);
        switch (typeCode) {
            case CONTROLLEDVOCABULARY: {
                basicProperty.setVocabularyTerm(VocabularyTermTranslator.translate(propertyPE.getVocabularyTerm()));
                break;
            }
            case MATERIAL: {
                basicProperty.setMaterial(MaterialTranslator.translate(propertyPE.getMaterialValue(), false, null, managedPropertyEvaluatorFactory, samplePropertyAccessValidator));
                break;
            }
            case SAMPLE: {
                SamplePE sampleProperty;
                if (!(propertyPE instanceof EntityPropertyWithSampleDataTypePE) || !samplePropertyAccessValidator.isValid(sampleProperty = ((EntityPropertyWithSampleDataTypePE)propertyPE).getSampleValue())) break;
                basicProperty.setSample(SampleTranslator.translateWithoutRevealingData(sampleProperty));
                break;
            }
            default: {
                basicProperty.setValue(propertyPE.tryGetUntypedValue());
            }
        }
        if (propertyPE.getEntityTypePropertyType().isManaged() && !rawManagedProperties) {
            result = PropertyTranslatorUtils.createManagedEntityProperty(propertyPE, basicProperty, managedPropertyEvaluatorFactory);
            PropertyTranslatorUtils.initializeEntityProperty(result, propertyType, ordinal);
        } else {
            result = basicProperty;
        }
        return result;
    }

    public static final List<IEntityProperty> translateRaw(Set<? extends EntityPropertyPE> list, Map<MaterialTypePE, MaterialType> materialTypeCache, Map<PropertyTypePE, PropertyType> cacheOrNull, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator) {
        if (list == null) {
            return null;
        }
        ArrayList<IEntityProperty> result = new ArrayList<IEntityProperty>();
        for (EntityPropertyPE entityPropertyPE : list) {
            result.add(EntityPropertyTranslator.translate(entityPropertyPE, materialTypeCache, cacheOrNull, true, managedPropertyEvaluatorFactory, samplePropertyAccessValidator));
        }
        return result;
    }

    public static final List<IEntityProperty> translate(Set<? extends EntityPropertyPE> list, Map<MaterialTypePE, MaterialType> materialTypeCache, Map<PropertyTypePE, PropertyType> cacheOrNull, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator) {
        if (list == null) {
            return null;
        }
        ArrayList<IEntityProperty> result = new ArrayList<IEntityProperty>();
        for (EntityPropertyPE entityPropertyPE : list) {
            result.add(EntityPropertyTranslator.translate(entityPropertyPE, materialTypeCache, cacheOrNull, managedPropertyEvaluatorFactory, samplePropertyAccessValidator));
        }
        return result;
    }

    public static final IEntityProperty[] translate(EntityPropertyPE[] list, Map<MaterialTypePE, MaterialType> materialTypeCache, Map<PropertyTypePE, PropertyType> cacheOrNull, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator) {
        if (list == null) {
            return null;
        }
        IEntityProperty[] result = new IEntityProperty[list.length];
        int idx = 0;
        for (EntityPropertyPE property : list) {
            result[idx++] = EntityPropertyTranslator.translate(property, materialTypeCache, cacheOrNull, managedPropertyEvaluatorFactory, samplePropertyAccessValidator);
        }
        return result;
    }
}

