/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystemType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;

public class ExternalDataManagementSystemTranslator {
    public static ExternalDataManagementSystem translate(ExternalDataManagementSystemPE edms) {
        if (edms == null) {
            return null;
        }
        ExternalDataManagementSystem result = new ExternalDataManagementSystem();
        result.setId(edms.getId());
        result.setCode(edms.getCode());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate());
        result.setLabel(edms.getLabel());
        result.setUrlTemplate(edms.getAddress());
        result.setAddress(edms.getAddress());
        if (edms.getAddressType() != null) {
            result.setAddressType(edms.getAddressType());
            result.setOpenBIS(ExternalDataManagementSystemType.OPENBIS.equals((Object)edms.getAddressType()));
        } else {
            result.setOpenBIS(edms.isOpenBIS());
            if (edms.isOpenBIS()) {
                result.setAddressType(ExternalDataManagementSystemType.OPENBIS);
            } else {
                result.setAddressType(ExternalDataManagementSystemType.URL);
            }
        }
        return result;
    }

    public static ExternalDataManagementSystemPE translate(ExternalDataManagementSystem edms, ExternalDataManagementSystemPE result) {
        result.setCode(edms.getCode());
        result.setLabel(edms.getLabel());
        if (edms.getAddress() != null) {
            result.setAddress(edms.getAddress());
        } else {
            result.setAddress(edms.getUrlTemplate());
        }
        if (edms.getAddressType() != null) {
            result.setAddressType(edms.getAddressType());
        } else if (edms.isOpenBIS()) {
            result.setAddressType(ExternalDataManagementSystemType.OPENBIS);
        } else {
            result.setAddressType(ExternalDataManagementSystemType.URL);
        }
        return result;
    }
}

