/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ScriptTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SampleTypeTranslator {
    private SampleTypeTranslator() {
    }

    public static SampleType translate(SampleTypePE sampleTypePE, Map<MaterialTypePE, MaterialType> materialTypeCache, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        if (sampleTypePE == null) {
            return null;
        }
        SampleType result = new SampleType();
        result.setId(HibernateUtils.getId(sampleTypePE));
        result.setCode(sampleTypePE.getCode());
        result.setListable(sampleTypePE.isListable());
        result.setDescription(sampleTypePE.getDescription());
        result.setGeneratedFromHierarchyDepth(sampleTypePE.getGeneratedFromHierarchyDepth());
        result.setContainerHierarchyDepth(sampleTypePE.getContainerHierarchyDepth());
        result.setSubcodeUnique(sampleTypePE.isSubcodeUnique());
        result.setAutoGeneratedCode(sampleTypePE.isAutoGeneratedCode());
        result.setShowParentMetadata(sampleTypePE.isShowParentMetadata());
        result.setGeneratedCodePrefix(sampleTypePE.getGeneratedCodePrefix());
        result.setSampleTypePropertyTypes(EntityType.sortedInternally(SampleTypePropertyTypeTranslator.translate(sampleTypePE.getSampleTypePropertyTypes(), result, materialTypeCache, cacheOrNull)));
        result.setModificationDate(sampleTypePE.getModificationDate());
        result.setValidationScript(ScriptTranslator.translate(sampleTypePE.getValidationScript()));
        return result;
    }

    public static List<SampleType> translate(List<SampleTypePE> sampleTypes, Map<MaterialTypePE, MaterialType> materialTypeCache, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ArrayList<SampleType> result = new ArrayList<SampleType>();
        for (SampleTypePE sampleTypePE : sampleTypes) {
            result.add(SampleTypeTranslator.translate(sampleTypePE, materialTypeCache, cacheOrNull));
        }
        return result;
    }

    public static SampleTypePE translate(SampleType sampleType) {
        SampleTypePE result = new SampleTypePE();
        result.setCode(sampleType.getCode());
        return result;
    }

    public static boolean getShowContainer(SampleTypePE sampleTypePE) {
        return sampleTypePE.getContainerHierarchyDepth() > 0;
    }
}

