/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.ArrayList;
import java.util.List;

public class SimpleDataSetHelper {
    public static final List<SimpleDataSetInformationDTO> filterAndTranslate(List<AbstractExternalData> externalData) {
        if (externalData == null) {
            return null;
        }
        ArrayList<SimpleDataSetInformationDTO> result = new ArrayList<SimpleDataSetInformationDTO>();
        for (AbstractExternalData ed : externalData) {
            if (!(ed instanceof PhysicalDataSet)) continue;
            PhysicalDataSet dataSet = (PhysicalDataSet)ed;
            result.add(SimpleDataSetHelper.translate(dataSet));
        }
        return result;
    }

    private static SimpleDataSetInformationDTO translate(PhysicalDataSet data) {
        Sample sample;
        SimpleDataSetInformationDTO result = new SimpleDataSetInformationDTO();
        result.setDataStoreCode(data.getDataStore().getCode());
        result.setDataSetCode(data.getCode());
        result.setRegistrationTimestamp(data.getRegistrationDate());
        result.setModificationTimestamp(data.getModificationDate());
        result.setAccessTimestamp(data.getAccessTimestamp());
        result.setSpeedHint(data.getSpeedHint());
        result.setDataSetShareId(data.getShareId());
        result.setDataSetLocation(data.getLocation());
        result.setStatus(data.getStatus());
        result.setPresentInArchive(data.isPresentInArchive());
        result.setDataSetSize(data.getSize());
        result.setSpaceCode(data.getSpace().getCode());
        result.setStorageConfirmed(data.isStorageConfirmation());
        Experiment experiment = data.getExperiment();
        if (experiment != null) {
            result.setExperimentCode(experiment.getCode());
            result.setProjectCode(experiment.getProject().getCode());
        }
        if ((sample = data.getSample()) != null) {
            result.setSampleCode(data.getSampleCode());
        }
        result.setDataSetType(data.getDataSetType().getCode());
        result.setDataStoreUrl(data.getDataStore().getHostUrl());
        List<ContainerDataSet> containerDataSets = data.getContainerDataSets();
        for (ContainerDataSet containerDataSet : containerDataSets) {
            String containerDataSetCode = containerDataSet.getCode();
            result.addOrderInContainer(containerDataSetCode, data.getOrderInContainer(containerDataSetCode));
        }
        result.setH5Folders(data.isH5Folders());
        result.setH5arFolders(data.isH5arFolders());
        return result;
    }

    public static SimpleDataSetInformationDTO translate(DatasetDescription datasetDescription) {
        SimpleDataSetInformationDTO result = new SimpleDataSetInformationDTO();
        result.setDataSetCode(datasetDescription.getDataSetCode());
        result.setRegistrationTimestamp(datasetDescription.getRegistrationTimestamp());
        result.setSpeedHint(datasetDescription.getSpeedHint());
        result.setDataSetLocation(datasetDescription.getDataSetLocation());
        result.setDataSetSize(datasetDescription.getDataSetSize());
        result.setDataSetType(datasetDescription.getDataSetTypeCode());
        result.setExperimentCode(datasetDescription.getExperimentCode());
        result.setSpaceCode(datasetDescription.getSpaceCode());
        result.setProjectCode(datasetDescription.getProjectCode());
        result.setSampleCode(datasetDescription.getSampleCode());
        result.setOrderInContainers(datasetDescription.getOrderInContainers());
        result.setStorageConfirmed(datasetDescription.isStorageConfirmed());
        return result;
    }
}

