/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.util.SimplePropertyValidator;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;

public class DataTypeUtils {
    private static final Map<DataTypeCode, Converter> map = new HashMap<DataTypeCode, Converter>();

    public static ISerializableComparable convertTo(DataTypeCode dataTypeCode, String value) {
        return Converter.resolve(dataTypeCode).convert(value);
    }

    public static Serializable convertValueTo(DataTypeCode dataTypeCode, String value) {
        return Converter.resolve(dataTypeCode).convertValue(value);
    }

    public static DataTypeCode getCompatibleDataType(DataTypeCode previousDataTypeOrNull, DataTypeCode dataType) {
        if (previousDataTypeOrNull == null) {
            return dataType;
        }
        if (dataType == null) {
            return previousDataTypeOrNull;
        }
        if (previousDataTypeOrNull == DataTypeCode.REAL) {
            if (dataType == DataTypeCode.REAL || dataType == DataTypeCode.INTEGER) {
                return DataTypeCode.REAL;
            }
            return DataTypeCode.VARCHAR;
        }
        if (previousDataTypeOrNull == DataTypeCode.INTEGER) {
            if (dataType == DataTypeCode.REAL) {
                return DataTypeCode.REAL;
            }
            if (dataType == DataTypeCode.INTEGER) {
                return DataTypeCode.INTEGER;
            }
            return DataTypeCode.VARCHAR;
        }
        if (previousDataTypeOrNull == DataTypeCode.TIMESTAMP && dataType == DataTypeCode.TIMESTAMP) {
            return DataTypeCode.TIMESTAMP;
        }
        return DataTypeCode.VARCHAR;
    }

    public static DataTypeCode getDataTypeCode(int sqlType) {
        if (DataTypeUtils.isInteger(sqlType)) {
            return DataTypeCode.INTEGER;
        }
        if (DataTypeUtils.isReal(sqlType)) {
            return DataTypeCode.REAL;
        }
        if (91 == sqlType || 93 == sqlType) {
            return DataTypeCode.TIMESTAMP;
        }
        return DataTypeCode.VARCHAR;
    }

    private static boolean isInteger(int sqlType) {
        return -5 == sqlType || 4 == sqlType || 5 == sqlType || -6 == sqlType;
    }

    private static boolean isReal(int sqlType) {
        return 3 == sqlType || 8 == sqlType || 6 == sqlType || 2 == sqlType || 7 == sqlType;
    }

    private DataTypeUtils() {
    }

    private static enum Converter implements Serializable
    {
        INTEGER(new DataTypeCode[]{DataTypeCode.INTEGER}){

            @Override
            public ISerializableComparable doConversion(String value) {
                return new IntegerTableCell(this.doSimpleConversion(value));
            }

            @Override
            public Long doSimpleConversion(String value) {
                try {
                    return new Long(value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Is not an integer number: " + value);
                }
            }
        }
        ,
        DOUBLE(new DataTypeCode[]{DataTypeCode.REAL}){

            @Override
            public ISerializableComparable doConversion(String value) {
                return new DoubleTableCell(this.doSimpleConversion(value));
            }

            @Override
            public Double doSimpleConversion(String value) {
                try {
                    return new Double(value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Is not a floating point number: " + value);
                }
            }
        }
        ,
        TIMESTAMP(new DataTypeCode[]{DataTypeCode.TIMESTAMP}){

            @Override
            public ISerializableComparable doConversion(String value) {
                return new DateTableCell(this.doSimpleConversion(value));
            }

            @Override
            public Date doSimpleConversion(String value) {
                try {
                    String pattern = SimplePropertyValidator.SupportedDatePattern.CANONICAL_DATE_PATTERN.getPattern();
                    return DateUtils.parseDate((String)value, (String[])new String[]{pattern});
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException("Is not a date in canonical format: " + value);
                }
            }
        }
        ,
        STRING(new DataTypeCode[]{DataTypeCode.VARCHAR, DataTypeCode.MULTILINE_VARCHAR, DataTypeCode.BOOLEAN, DataTypeCode.XML, DataTypeCode.CONTROLLEDVOCABULARY, DataTypeCode.MATERIAL, DataTypeCode.HYPERLINK, DataTypeCode.SAMPLE, DataTypeCode.DATE}){

            @Override
            public ISerializableComparable doConversion(String value) {
                return new StringTableCell(value);
            }

            @Override
            public Serializable doSimpleConversion(String value) {
                return value;
            }
        };

        private static final StringTableCell EMPTY_CELL;

        private Converter(DataTypeCode ... codes) {
            for (DataTypeCode dataTypeCode : codes) {
                map.put(dataTypeCode, this);
            }
        }

        public static Converter resolve(DataTypeCode dataTypeCode) {
            return (Converter)map.get(dataTypeCode);
        }

        public ISerializableComparable convert(String value) {
            if (StringUtils.isBlank(value)) {
                return EMPTY_CELL;
            }
            if (value.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX)) {
                return new StringTableCell(value.substring(1));
            }
            return this.doConversion(value);
        }

        public Serializable convertValue(String value) {
            return StringUtils.isBlank(value) ? null : this.doSimpleConversion(value);
        }

        protected abstract ISerializableComparable doConversion(String var1);

        protected abstract Serializable doSimpleConversion(String var1);

        static {
            EMPTY_CELL = new StringTableCell("");
        }
    }
}

