/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityHelper {
    public static <T extends IIdHolder> boolean equalEntities(T entity1OrNull, T entity2OrNull) {
        if (entity1OrNull == null || entity2OrNull == null) {
            return entity1OrNull == entity2OrNull;
        }
        if (!entity1OrNull.getClass().equals(entity2OrNull.getClass())) {
            return false;
        }
        Long id1 = HibernateUtils.getId(entity1OrNull);
        Long id2 = HibernateUtils.getId(entity2OrNull);
        return id1 == null ? id1 == id2 : id1.equals(id2);
    }

    public static EntityType createEntityType(EntityKind kind, String code) {
        EntityType type = null;
        switch (kind) {
            case DATA_SET: {
                type = new DataSetType();
                break;
            }
            case EXPERIMENT: {
                type = new ExperimentType();
                break;
            }
            case MATERIAL: {
                type = new MaterialType();
                break;
            }
            case SAMPLE: {
                type = new SampleType();
                break;
            }
            default: {
                throw new Error("Unknown kind '" + kind + "'");
            }
        }
        type.setCode(code);
        return type;
    }

    public static IEntityProperty tryFindProperty(Iterable<IEntityProperty> properties, String propertyCode) {
        for (IEntityProperty property : properties) {
            PropertyType propertyType = property.getPropertyType();
            if (!propertyType.getCode().equalsIgnoreCase(propertyCode)) continue;
            return property;
        }
        return null;
    }

    public static IEntityProperty tryFindProperty(IEntityProperty[] properties, String propertyCode) {
        for (IEntityProperty property : properties) {
            PropertyType propertyType = property.getPropertyType();
            if (!propertyType.getCode().equalsIgnoreCase(propertyCode)) continue;
            return property;
        }
        return null;
    }

    public static boolean removeProperty(List<NewProperty> properties, String propertyCode) {
        NewProperty property = EntityHelper.tryFindProperty(properties, propertyCode);
        if (property != null) {
            properties.remove(property);
            return true;
        }
        return false;
    }

    public static NewProperty tryFindProperty(List<NewProperty> properties, String propertyCode) {
        for (NewProperty property : properties) {
            if (!property.getPropertyCode().equalsIgnoreCase(propertyCode)) continue;
            return property;
        }
        return null;
    }

    public static String tryFindPropertyValue(IEntityPropertiesHolder holder, String propertyCode) {
        EntityPropertyPE property = null;
        if (holder != null && holder.getProperties() != null) {
            property = EntityHelper.tryFindProperty(holder.getProperties(), propertyCode);
        }
        return property != null ? property.tryGetUntypedValue() : null;
    }

    private static EntityPropertyPE tryFindProperty(Set<? extends EntityPropertyPE> properties, String propertyCode) {
        for (EntityPropertyPE entityPropertyPE : properties) {
            PropertyTypePE propertyType = entityPropertyPE.getEntityTypePropertyType().getPropertyType();
            if (!propertyType.getCode().equalsIgnoreCase(propertyCode)) continue;
            return entityPropertyPE;
        }
        return null;
    }

    public static String tryFindPropertyValue(ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder holder, String propertyCode) {
        IEntityProperty property = null;
        if (holder != null && holder.getProperties() != null) {
            property = EntityHelper.tryFindProperty(holder.getProperties(), propertyCode);
        }
        return property != null ? property.tryGetOriginalValue() : null;
    }

    public static void updateSampleProperties(ICommonServer server, String sessionToken, Sample sample, Map<String, String> properties) {
        List<IEntityProperty> props = EntityHelper.translatePropertiesMapToList(properties);
        ExperimentIdentifier experimentIdentifier = ExperimentIdentifierFactory.tryGetExperimentIdentifier(sample);
        ProjectIdentifier projectIdentifier = ProjectIdentifierFactory.tryGetProjectIdentifier(sample);
        SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(sample.getIdentifier());
        Sample container = sample.getContainer();
        String containerIdentifier = container == null ? null : container.getIdentifier();
        SampleUpdatesDTO updates = new SampleUpdatesDTO(new TechId(sample), props, experimentIdentifier, projectIdentifier, Collections.emptySet(), sample.getVersion(), sampleIdentifier, containerIdentifier, null);
        server.updateSample(sessionToken, updates);
    }

    public static void updateSampleProperties(ICommonServer server, String sessionToken, TechId id, Map<String, String> properties) {
        Sample sample = server.getSampleInfo(sessionToken, id).getParent();
        EntityHelper.updateSampleProperties(server, sessionToken, sample, properties);
    }

    public static List<IEntityProperty> translatePropertiesMapToList(Map<String, String> properties) {
        ArrayList<IEntityProperty> props = new ArrayList<IEntityProperty>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            props.add(EntityHelper.createNewProperty(entry.getKey(), entry.getValue()));
        }
        return props;
    }

    public static void createOrUpdateProperty(ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder holder, String propertyCode, String propertyValue) {
        IEntityProperty newProperty = EntityHelper.createNewProperty(propertyCode, propertyValue);
        List<IEntityProperty> properties = holder.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            IEntityProperty property = properties.get(i);
            PropertyType propertyType = property.getPropertyType();
            if (!propertyType.getCode().equalsIgnoreCase(propertyCode)) continue;
            properties.set(i, newProperty);
            return;
        }
        properties.add(newProperty);
    }

    public static IEntityProperty createNewProperty(String propertyCode, String propertyValue) {
        IEntityProperty property = EntityHelper.createNewProperty(propertyCode);
        property.setValue(propertyValue);
        return property;
    }

    public static Map<String, String> convertToStringMap(List<IEntityProperty> properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (properties != null) {
            for (IEntityProperty prop : properties) {
                map.put(prop.getPropertyType().getCode(), prop.tryGetAsString());
            }
        }
        return map;
    }

    private static IEntityProperty createNewProperty(String propertyCode) {
        EntityProperty property = new EntityProperty();
        PropertyType propertyType = new PropertyType();
        propertyType.setCode(propertyCode);
        property.setPropertyType(propertyType);
        return property;
    }
}

