/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.parser.MemorySizeFormatter;
import ch.systemsx.cisd.common.parser.PercentFormatter;
import ch.systemsx.cisd.openbis.generic.shared.util.RuntimeCacheEventListenerFactory;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.MemoryUnit;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.log4j.Logger;

public class RuntimeCache<K, V> {
    private final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RuntimeCache.class);
    private CacheManager cacheManager;
    private String name;
    private String cacheSizePropertyName;

    public RuntimeCache(CacheManager cacheManager, String name, String cacheSizePropertyName) {
        this.cacheManager = cacheManager;
        this.name = name;
        this.cacheSizePropertyName = cacheSizePropertyName;
    }

    public V get(K key) {
        Element element = this.getCache().get(key);
        return element == null ? null : (V)((ValueWrapper)element.getObjectValue()).getValue();
    }

    public void put(K key, V value) {
        Element element = this.getCache().get(key);
        if (element == null) {
            this.getCache().put(new Element(key, new ValueWrapper<V>(value)));
        } else {
            ValueWrapper existingValue = (ValueWrapper)element.getObjectValue();
            existingValue.setValue(value);
            RuntimeCacheEventListenerFactory.getListener().notifyElementUpdated((Ehcache)this.getCache(), element);
            this.getCache().recalculateSize(key);
        }
    }

    public boolean remove(K key) {
        return this.getCache().remove(key);
    }

    public List<K> getKeys() {
        return this.getCache().getKeys();
    }

    public List<V> getValues() {
        ArrayList<V> values = new ArrayList<V>(this.getKeys().size());
        for (K key : this.getKeys()) {
            values.add(this.get(key));
        }
        return values;
    }

    public void initCache() {
        Cache cache = this.cacheManager.getCache(this.name);
        if (cache == null) {
            this.operationLog.info((Object)("Creating the cache: " + this.name));
            CacheConfiguration config = new CacheConfiguration();
            config.setName(this.name);
            config.setEternal(false);
            config.maxBytesLocalHeap(this.getCacheSize(), MemoryUnit.BYTES);
            config.persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.NONE));
            config.setTimeToIdleSeconds(3600L);
            config.setTimeToLiveSeconds(0L);
            config.memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU);
            config.addCacheEventListenerFactory((CacheConfiguration.CacheEventListenerFactoryConfiguration)new CacheConfiguration.CacheEventListenerFactoryConfiguration().className(RuntimeCacheEventListenerFactory.class.getName()));
            config.sizeOfPolicy(new SizeOfPolicyConfiguration().maxDepth(10000000).maxDepthExceededBehavior(SizeOfPolicyConfiguration.MaxDepthExceededBehavior.CONTINUE));
            cache = new Cache(config);
            this.cacheManager.addCache(cache);
        } else {
            this.operationLog.info((Object)("The cache " + this.name + " already exists. It must have been configured in ehcache.xml file."));
        }
    }

    protected long getCacheSize() {
        String propertyValue = this.getSystemProperty(this.cacheSizePropertyName);
        if (propertyValue == null || propertyValue.trim().length() == 0) {
            return this.getCacheDefaultSize();
        }
        try {
            long cacheSize = MemorySizeFormatter.parse(propertyValue);
            this.operationLog.info((Object)("Cache size was set to '" + propertyValue + "' in '" + this.cacheSizePropertyName + "' system property."));
            return cacheSize;
        }
        catch (IllegalArgumentException e1) {
            try {
                int cachePercent = PercentFormatter.parse(propertyValue);
                long cacheSize = (long)((double)cachePercent / 100.0 * (double)this.getMemorySize());
                this.operationLog.info((Object)("Cache size was set to '" + propertyValue + "' in '" + this.cacheSizePropertyName + "' system property. The memory available to the JVM is " + MemorySizeFormatter.format(this.getMemorySize()) + " which gives a cache size of " + MemorySizeFormatter.format(cacheSize)));
                return cacheSize;
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("Cache size was set to '" + propertyValue + "' in '" + this.cacheSizePropertyName + "' system property. This value is incorrect. Please set the property to an absolute value like '512m' or '1g'. You can also use a value like '25%' to set the cache size relative to the memory available to the JVM.");
            }
        }
    }

    protected long getMemorySize() {
        return Runtime.getRuntime().maxMemory();
    }

    protected String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    private Cache getCache() {
        return this.cacheManager.getCache(this.name);
    }

    private long getCacheDefaultSize() {
        long memorySize = this.getMemorySize();
        long cacheSize = memorySize / 4L;
        this.operationLog.info((Object)("Cache size has been set to its default value. The default value is 25% (" + MemorySizeFormatter.format(cacheSize) + ") of the memory available to the JVM (" + MemorySizeFormatter.format(memorySize) + "). If you would like to change this value, then please set '" + this.cacheSizePropertyName + "' system property in openbis.conf file."));
        return cacheSize;
    }

    private static final class ValueWrapper<V> {
        private V value;

        ValueWrapper(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

