/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.log4j.Logger;

public class RuntimeCacheEventListener
implements CacheEventListener {
    private final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, this.getClass());

    public void dispose() {
        this.operationLog.info((Object)"Disposing cache listener");
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        this.logOperation(cache, element, "has been evicted from the cache");
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        this.logOperation(cache, element, "has expired");
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        this.logOperation(cache, element, "has been put to the cache");
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this.logOperation(cache, element, "has been removed from the cache");
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        this.logOperation(cache, element, "has been updated");
    }

    public void notifyRemoveAll(Ehcache cache) {
        this.operationLog.info((Object)"All entries have been removed from the cache.");
    }

    private void logOperation(Ehcache cache, Element element, String operation) {
        Object entry = element.getObjectValue();
        if (entry != null && this.operationLog.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cache entry " + entry.hashCode() + " that contains " + entry + " " + operation + ".");
            int cacheSize = cache.getSize();
            if (cacheSize == 1) {
                sb.append(" Cache now contains 1 entry.");
            } else {
                sb.append(" Cache now contains " + cacheSize + " entries.");
            }
            this.operationLog.info((Object)sb.toString());
        }
    }

    public Object clone() {
        return new RuntimeCacheEventListener();
    }
}

