/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.ValidationUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SimplePropertyValidator {
    public static final String[] DATE_PATTERNS = SimplePropertyValidator.createDatePatterns();
    private static final Map<DataTypeCode, IDataTypeValidator> dataTypeValidators = SimplePropertyValidator.createDataTypeValidators();

    private static final Map<DataTypeCode, IDataTypeValidator> createDataTypeValidators() {
        EnumMap<DataTypeCode, IDataTypeValidator> map = new EnumMap<DataTypeCode, IDataTypeValidator>(DataTypeCode.class);
        map.put(DataTypeCode.BOOLEAN, new BooleanValidator());
        map.put(DataTypeCode.VARCHAR, new VarcharValidator());
        map.put(DataTypeCode.DATE, new DateValidator());
        map.put(DataTypeCode.TIMESTAMP, new TimestampValidator());
        map.put(DataTypeCode.INTEGER, new IntegerValidator());
        map.put(DataTypeCode.REAL, new RealValidator());
        map.put(DataTypeCode.HYPERLINK, new HyperlinkValidator());
        map.put(DataTypeCode.MULTILINE_VARCHAR, new VarcharValidator());
        return map;
    }

    private static final String[] createDatePatterns() {
        ArrayList<String> datePatterns = new ArrayList<String>();
        for (SupportedDatePattern supportedPattern : SupportedDatePattern.values()) {
            datePatterns.add(supportedPattern.getPattern());
        }
        return datePatterns.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public boolean canValidate(DataTypeCode entityDataType) {
        return null != dataTypeValidators.get(entityDataType);
    }

    public final String validatePropertyValue(DataTypeCode entityDataType, String value) throws UserFailureException {
        assert (value != null) : "Unspecified value.";
        if (value.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX)) {
            return value;
        }
        IDataTypeValidator dataTypeValidator = dataTypeValidators.get(entityDataType);
        assert (dataTypeValidator != null) : String.format("No IDataTypeValidator implementation specified for '%s'.", entityDataType);
        return dataTypeValidator.validate(value);
    }

    private static final class HyperlinkValidator
    implements IDataTypeValidator {
        private HyperlinkValidator() {
        }

        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            if (!ValidationUtilities.HyperlinkValidationHelper.isProtocolValid(value)) {
                throw UserFailureException.fromTemplate("Hyperlink '%s' should start with one of the following protocols: '%s'", value, ValidationUtilities.HyperlinkValidationHelper.getValidProtocolsAsString());
            }
            if (!ValidationUtilities.HyperlinkValidationHelper.isFormatValid(value)) {
                throw UserFailureException.fromTemplate("Hyperlink value '%s' has improper format.", value);
            }
            return value;
        }
    }

    public static final class RealValidator
    implements IDataTypeValidator {
        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            try {
                double doubleValue = Double.parseDouble(value);
                return String.valueOf(doubleValue);
            }
            catch (NumberFormatException ex) {
                throw UserFailureException.fromTemplate("Double value '%s' has improper format.", value);
            }
        }
    }

    public static final class IntegerValidator
    implements IDataTypeValidator {
        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            try {
                long longValue = Long.parseLong(value);
                return String.valueOf(longValue);
            }
            catch (NumberFormatException ex) {
                throw UserFailureException.fromTemplate("Integer value '%s' has improper format.", value);
            }
        }
    }

    private static class AbstractDateAndTimestampValidator
    implements IDataTypeValidator {
        private SupportedDatePattern internalPattern;
        private String[] patterns;

        AbstractDateAndTimestampValidator(SupportedDatePattern internalPattern, String ... patterns) {
            this.internalPattern = internalPattern;
            this.patterns = patterns;
        }

        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            try {
                this.validateHyphens(value);
                Date date = DateUtils.parseDateStrictly((String)value, (String[])this.patterns);
                return DateFormatUtils.format((Date)date, (String)this.internalPattern.getPattern());
            }
            catch (IllegalArgumentException | ParseException ex) {
                this.throwUserFailureException(value);
                return null;
            }
        }

        private void validateHyphens(String value) throws UserFailureException {
            if (value == null) {
                return;
            }
            int indexOfHyphen = value.indexOf(45);
            if (indexOfHyphen >= 0 && indexOfHyphen != 4) {
                this.throwUserFailureException(value);
            }
        }

        private void throwUserFailureException(String value) throws UserFailureException {
            String validValues = "[" + String.join((CharSequence)"\n", this.patterns) + "]";
            throw UserFailureException.fromTemplate("Date value '%s' has improper format. It must be one of '%s'.", value, validValues);
        }
    }

    public static final class TimestampValidator
    extends AbstractDateAndTimestampValidator {
        public TimestampValidator() {
            super(SupportedDatePattern.CANONICAL_DATE_PATTERN, DATE_PATTERNS);
        }
    }

    public static final class DateValidator
    extends AbstractDateAndTimestampValidator {
        public DateValidator() {
            super(SupportedDatePattern.DAYS_DATE_PATTERN, SupportedDatePattern.DAYS_DATE_PATTERN.getPattern(), SupportedDatePattern.US_DATE_PATTERN.getPattern());
        }
    }

    private static final class VarcharValidator
    implements IDataTypeValidator {
        private VarcharValidator() {
        }

        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            return value;
        }
    }

    public static final class BooleanValidator
    implements IDataTypeValidator {
        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            PropertyUtils.Boolean bool = PropertyUtils.Boolean.getBoolean(value);
            if (bool == null) {
                throw UserFailureException.fromTemplate("Boolean value '%s' has improper format. It should be either 'true' or 'false'.", value);
            }
            return Boolean.toString(bool.toBoolean());
        }
    }

    public static interface IDataTypeValidator {
        public String validate(String var1) throws UserFailureException;
    }

    public static enum SupportedDatePattern {
        DAYS_DATE_PATTERN("yyyy-MM-dd"),
        MINUTES_DATE_PATTERN("yyyy-MM-dd HH:mm"),
        SECONDS_DATE_PATTERN("yyyy-MM-dd HH:mm:ss"),
        ISO_MINUTES_DATE_PATTERN("yyyy-MM-dd'T'HH:mm"),
        ISO_SECONDS_DATE_PATTERN("yyyy-MM-dd'T'HH:mm:ss"),
        US_DATE_PATTERN("M/d/yy"),
        US_DATE_TIME_PATTERN("M/d/yy h:mm a"),
        US_DATE_TIME_24_PATTERN("M/d/yy HH:mm"),
        CANONICAL_DATE_PATTERN("yyyy-MM-dd HH:mm:ss Z"),
        ISO_CANONICAL_DATE_PATTERN("yyyy-MM-dd'T'HH:mm:ssX"),
        RENDERED_CANONICAL_DATE_PATTERN("yyyy-MM-dd HH:mm:ss Z"),
        ISO_RENDERED_CANONICAL_DATE_PATTERN("yyyy-MM-dd'T'HH:mm:ssXXX");

        private final String pattern;

        private SupportedDatePattern(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

