/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.common.utilities.Counters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.util.DataTypeUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.IRowBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleTableModelBuilder {
    private final List<TableModelRow> rows;
    private final List<TableModelColumnHeader> headers;
    private final Counters<String> counters = new Counters();
    private final Map<String, Integer> titleToIndexMap;
    private final boolean uniqueHeaderTitles;
    private String messageOrNull;

    public SimpleTableModelBuilder() {
        this(false);
    }

    public SimpleTableModelBuilder(boolean uniqueHeaderTitles) {
        this.uniqueHeaderTitles = uniqueHeaderTitles;
        this.rows = new ArrayList<TableModelRow>();
        this.headers = new ArrayList<TableModelColumnHeader>();
        this.titleToIndexMap = new HashMap<String, Integer>();
    }

    public void addHeader(String title) {
        this.addHeader(title, 150);
    }

    public void addHeader(String title, String code) {
        this.addHeader(title, code, 150);
    }

    public void addHeader(String title, int defaultColumnWidth) {
        this.addHeader(title, title, defaultColumnWidth);
    }

    private void addHeader(String title, String code, int defaultColumnWidth) {
        String id = this.createUniqueID(code);
        TableModelColumnHeader header = new TableModelColumnHeader(title, id, this.headers.size());
        header.setDefaultColumnWidth(defaultColumnWidth);
        Integer replacedValue = this.titleToIndexMap.put(title, this.headers.size());
        if (this.uniqueHeaderTitles && replacedValue != null) {
            throw new UserFailureException("There is already a header with title '" + title + "'.");
        }
        this.headers.add(header);
    }

    private String createUniqueID(String code) {
        int count = this.counters.count(code);
        return count == 1 ? code : code + count;
    }

    public IRowBuilder addRow() {
        if (!this.uniqueHeaderTitles) {
            throw new UnsupportedOperationException("Method only supported for unique header titles.");
        }
        final ArrayList<ISerializableComparable> values = new ArrayList<ISerializableComparable>();
        StringTableCell emptyCell = new StringTableCell("");
        for (int i = 0; i < this.headers.size(); ++i) {
            values.add(emptyCell);
        }
        this.rows.add(new TableModelRow(values));
        return new IRowBuilder(){

            @Override
            public void setCell(String headerTitle, String value) {
                this.setCell(headerTitle, SimpleTableModelBuilder.asText(value));
            }

            @Override
            public void setCell(String headerTitle, long value) {
                this.setCell(headerTitle, SimpleTableModelBuilder.asInteger(value));
            }

            @Override
            public void setCell(String headerTitle, double value) {
                this.setCell(headerTitle, SimpleTableModelBuilder.asDouble(value));
            }

            @Override
            public void setCell(String headerTitle, Date value) {
                this.setCell(headerTitle, SimpleTableModelBuilder.asDate(value));
            }

            @Override
            public void setCell(String headerTitle, ISerializableComparable value) {
                Integer index = (Integer)SimpleTableModelBuilder.this.titleToIndexMap.get(headerTitle);
                if (index == null) {
                    throw new UserFailureException("Unkown column header title: " + headerTitle);
                }
                values.set(index, value);
                SimpleTableModelBuilder.this.setColumnDataType(index, value);
                SimpleTableModelBuilder.this.setColumnEntityKind(index, value);
            }
        };
    }

    public void addRow(List<ISerializableComparable> values) {
        if (values.size() != this.headers.size()) {
            throw new UserFailureException(this.headers.size() + " row values expected instead of " + values.size() + ".");
        }
        for (int i = 0; i < values.size(); ++i) {
            ISerializableComparable value = values.get(i);
            this.setColumnDataType(i, value);
            this.setColumnEntityKind(i, value);
        }
        this.rows.add(new TableModelRow(values));
    }

    private void setColumnDataType(int index, ISerializableComparable value) {
        TableModelColumnHeader header = this.headers.get(index);
        DataTypeCode headerDataType = header.getDataType();
        DataTypeCode dataType = this.getDataTypeCodeFor(value);
        if (value != null && !StringUtils.isBlank(value.toString())) {
            DataTypeCode compatibleDataType = DataTypeUtils.getCompatibleDataType(headerDataType, dataType);
            header.setDataType(compatibleDataType);
        }
    }

    private void setColumnEntityKind(Integer index, ISerializableComparable value) {
        TableModelColumnHeader header = this.headers.get(index);
        EntityKind headerEntityKind = header.tryGetEntityKind();
        EntityKind dataEntityKind = this.getEntityKindFor(value);
        if (dataEntityKind != null && (headerEntityKind == null || dataEntityKind.equals(headerEntityKind))) {
            header.setEntityKind(dataEntityKind);
        }
    }

    private EntityKind getEntityKindFor(ISerializableComparable value) {
        if (value instanceof EntityTableCell) {
            return ((EntityTableCell)value).getEntityKind();
        }
        return null;
    }

    private DataTypeCode getDataTypeCodeFor(ISerializableComparable value) {
        if (value instanceof IntegerTableCell) {
            return DataTypeCode.INTEGER;
        }
        if (value instanceof DoubleTableCell) {
            return DataTypeCode.REAL;
        }
        if (value instanceof DateTableCell) {
            return DataTypeCode.TIMESTAMP;
        }
        return DataTypeCode.VARCHAR;
    }

    public SimpleTableModelBuilder addFullHeader(String ... titles) {
        for (String title : titles) {
            this.addHeader(title);
        }
        return this;
    }

    public SimpleTableModelBuilder addFullRow(String ... values) {
        ArrayList<ISerializableComparable> rowValues = new ArrayList<ISerializableComparable>();
        for (String value : values) {
            rowValues.add(SimpleTableModelBuilder.asText(value));
        }
        this.addRow(rowValues);
        return this;
    }

    public String tryGetMessage() {
        return this.messageOrNull;
    }

    public void setMessage(String message) {
        this.messageOrNull = message;
    }

    public TableModel getTableModel() {
        return new TableModel(this.headers, this.rows);
    }

    public static ISerializableComparable asText(String textOrNull) {
        if (textOrNull == null) {
            return SimpleTableModelBuilder.createNullCell();
        }
        return new StringTableCell(textOrNull);
    }

    public static ISerializableComparable asInteger(long num) {
        return new IntegerTableCell(num);
    }

    public static ISerializableComparable asDouble(double num) {
        return new DoubleTableCell(num);
    }

    public static ISerializableComparable asDate(Date dateOrNull) {
        if (dateOrNull == null) {
            return SimpleTableModelBuilder.createNullCell();
        }
        return new DateTableCell(dateOrNull);
    }

    static ISerializableComparable createNullCell() {
        return new StringTableCell("");
    }
}

