/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class UuidUtil {
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", 2);

    private UuidUtil() {
    }

    public static final String generateUUID() {
        return CodeConverter.tryToDatabase(UUID.randomUUID().toString());
    }

    public static final boolean isValidUUID(String uuid) {
        assert (uuid != null) : "Unspecified UUID";
        String[] split = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)uuid, (String)"-");
        if (split.length != 5) {
            return false;
        }
        return UUID_PATTERN.matcher(uuid).matches();
    }
}

