/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.openbis.generic.shared.WebClientConfigurationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;

public class WebClientConfigUtils {
    public static String getTranslatedDescription(WebClientConfigurationProvider provider, SearchableEntity entity) {
        String description = entity.getDescription();
        WebClientConfiguration webClientConfiguration = WebClientConfigUtils.getWebClientConfiguration(provider);
        if (webClientConfiguration != null) {
            if (entity == SearchableEntity.SAMPLE) {
                description = webClientConfiguration.getSampleText();
            } else if (entity == SearchableEntity.EXPERIMENT) {
                description = webClientConfiguration.getExperimentText();
            }
        }
        return description;
    }

    public static String getTranslatedDescription(WebClientConfigurationProvider provider, EntityKind entityKind) {
        String description = entityKind.getDescription();
        WebClientConfiguration webClientConfiguration = WebClientConfigUtils.getWebClientConfiguration(provider);
        if (webClientConfiguration != null) {
            if (entityKind == EntityKind.SAMPLE) {
                description = webClientConfiguration.getSampleText();
            } else if (entityKind == EntityKind.EXPERIMENT) {
                description = webClientConfiguration.getExperimentText();
            }
        }
        return description;
    }

    public static String getSampleText(WebClientConfigurationProvider provider) {
        return WebClientConfigUtils.getWebClientConfiguration(provider).getSampleText();
    }

    public static String getExperimentText(WebClientConfigurationProvider provider) {
        return WebClientConfigUtils.getWebClientConfiguration(provider).getExperimentText();
    }

    private static WebClientConfiguration getWebClientConfiguration(WebClientConfigurationProvider provider) {
        return provider == null ? null : provider.getWebClientConfiguration();
    }
}

