/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryTableColumn;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryTableColumnDataType;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.TypedStringValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonObject(value="QueryTableModel")
public class QueryTableModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<QueryTableColumn> columns;
    private List<Serializable[]> rows;

    public QueryTableModel(List<QueryTableColumn> columns) {
        this.columns = columns;
        this.rows = new ArrayList<Serializable[]>();
    }

    public List<QueryTableColumn> getColumns() {
        return this.columns;
    }

    public void addRow(Serializable[] values) {
        if (values == null) {
            throw new IllegalArgumentException("Unspecified row.");
        }
        if (values.length != this.columns.size()) {
            throw new IllegalArgumentException("Row has " + values.length + " instead of " + this.columns.size() + ".");
        }
        this.rows.add(values);
    }

    @JsonIgnore
    public List<Serializable[]> getRows() {
        return this.rows;
    }

    private QueryTableModel() {
        this.columns = new ArrayList<QueryTableColumn>();
        this.rows = new ArrayList<Serializable[]>();
    }

    private void setColumns(List<QueryTableColumn> columns) {
        this.columns = columns;
    }

    @JsonProperty(value="rows")
    private List<TypedStringValue[]> getTypedRows() {
        ArrayList<TypedStringValue[]> typedRows = new ArrayList<TypedStringValue[]>(this.rows.size());
        for (Serializable[] row : this.rows) {
            TypedStringValue[] typedRow = new TypedStringValue[row.length];
            typedRows.add(typedRow);
            for (int i = 0; i < row.length; ++i) {
                Serializable value = row[i];
                if (value instanceof Long) {
                    typedRow[i] = new TypedStringValue(QueryTableColumnDataType.LONG, value.toString());
                    continue;
                }
                if (value instanceof Double) {
                    typedRow[i] = new TypedStringValue(QueryTableColumnDataType.DOUBLE, value.toString());
                    continue;
                }
                if (value instanceof String) {
                    typedRow[i] = new TypedStringValue(QueryTableColumnDataType.STRING, value.toString());
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert " + value + " to a long, double, or String.");
            }
        }
        return typedRows;
    }

    @JsonProperty(value="rows")
    private void setTypedRows(List<TypedStringValue[]> typedRows) {
        this.rows = new ArrayList<Serializable[]>(typedRows.size());
        for (TypedStringValue[] typedRow : typedRows) {
            Serializable[] row = new Serializable[typedRow.length];
            this.rows.add(row);
            for (int i = 0; i < row.length; ++i) {
                row[i] = typedRow[i].toSerializable();
            }
        }
    }
}

