/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.concurrent.IActivitySensor;
import ch.systemsx.cisd.common.concurrent.ITerminableFuture;
import ch.systemsx.cisd.common.concurrent.TerminableCallable;
import ch.systemsx.cisd.common.concurrent.TerminableFuture;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ConcurrencyUtilities {
    public static final long NO_TIMEOUT = -1L;
    public static final long IMMEDIATE_TIMEOUT = 0L;

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis) throws InterruptedExceptionUnchecked {
        return ConcurrencyUtilities.tryGetResult(future, timeoutMillis, null, true);
    }

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        return ConcurrencyUtilities.tryGetResult(future, timeoutMillis, null, stopOnInterrupt);
    }

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis, ILogSettings logSettingsOrNull, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        ExecutionResult<T> result = ConcurrencyUtilities.getResult(future, timeoutMillis, logSettingsOrNull);
        return ConcurrencyUtilities.tryDealWithResult(result, stopOnInterrupt);
    }

    public static <T> T tryDealWithResult(ExecutionResult<T> result) {
        return ConcurrencyUtilities.tryDealWithResult(result, true);
    }

    public static <T> T tryDealWithResult(ExecutionResult<T> result, boolean stopOnInterrupt) {
        switch (result.getStatus()) {
            case COMPLETE: {
                return result.tryGetResult();
            }
            case EXCEPTION: {
                Throwable cause = result.tryGetException();
                assert (cause != null);
                throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)cause);
            }
            case INTERRUPTED: {
                if (stopOnInterrupt) {
                    throw new InterruptedExceptionUnchecked();
                }
                return null;
            }
        }
        return null;
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis) {
        return ConcurrencyUtilities.getResult(future, timeoutMillis, null);
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis, ILogSettings logSettingsOrNull) {
        return ConcurrencyUtilities.getResult(future, timeoutMillis, true, logSettingsOrNull);
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis, boolean cancelOnTimeout, ILogSettings logSettingsOrNull) {
        return ConcurrencyUtilities.getResult(future, timeoutMillis, cancelOnTimeout, logSettingsOrNull, null, null);
    }

    private static boolean isActive(IActivitySensor sensorOrNull, long timeoutMillis) {
        return sensorOrNull != null && sensorOrNull.hasActivityMoreRecentThan(timeoutMillis);
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis, boolean cancelOnTimeout, ILogSettings logSettingsOrNull, ICancellationNotifier cancellationNotifierOrNull, IActivitySensor sensorOrNull) {
        try {
            ExecutionResult<T> result = null;
            do {
                try {
                    result = ExecutionResult.create(future.get(ConcurrencyUtilities.transform(timeoutMillis), TimeUnit.MILLISECONDS));
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            } while (result == null && ConcurrencyUtilities.isActive(sensorOrNull, timeoutMillis));
            if (result == null) {
                if (cancelOnTimeout) {
                    if (cancellationNotifierOrNull != null) {
                        cancellationNotifierOrNull.willCancel();
                    }
                    future.cancel(true);
                }
                if (logSettingsOrNull != null) {
                    logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: timeout of %.2f s exceeded%s.", logSettingsOrNull.getOperationName(), Float.valueOf((float)timeoutMillis / 1000.0f), cancelOnTimeout ? ", cancelled" : ""));
                }
                return ExecutionResult.createTimedOut();
            }
            if (logSettingsOrNull != null && logSettingsOrNull.getLogLevelForSuccess() != LogLevel.OFF) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForSuccess(), String.format("%s: call returns %s.", logSettingsOrNull.getOperationName(), result.tryGetResult()));
            }
            return result;
        }
        catch (InterruptedException ex) {
            if (cancellationNotifierOrNull != null) {
                cancellationNotifierOrNull.willCancel();
            }
            future.cancel(true);
            if (logSettingsOrNull != null) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: interrupted.", logSettingsOrNull.getOperationName()));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (InterruptedExceptionUnchecked ex) {
            if (cancellationNotifierOrNull != null) {
                cancellationNotifierOrNull.willCancel();
            }
            future.cancel(true);
            if (logSettingsOrNull != null) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: stopped.", logSettingsOrNull.getOperationName()));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (ThreadDeath ex) {
            if (cancellationNotifierOrNull != null) {
                cancellationNotifierOrNull.willCancel();
            }
            future.cancel(true);
            if (logSettingsOrNull != null) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: stopped.", logSettingsOrNull.getOperationName()));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (CancellationException ex) {
            if (logSettingsOrNull != null) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: cancelled.", logSettingsOrNull.getOperationName()));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof InterruptedExceptionUnchecked) {
                if (cancellationNotifierOrNull != null) {
                    cancellationNotifierOrNull.willCancel();
                }
                future.cancel(true);
                if (logSettingsOrNull != null) {
                    logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: interrupted.", logSettingsOrNull.getOperationName()));
                }
                return ExecutionResult.createInterrupted();
            }
            if (logSettingsOrNull != null) {
                String message = cause == null || cause.getMessage() == null ? "<no message>" : cause.getMessage();
                String className = cause == null ? "<unknown class>" : cause.getClass().getSimpleName();
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: exception: %s [%s].", logSettingsOrNull.getOperationName(), message, className));
            }
            return ExecutionResult.createExceptional(cause == null ? ex : cause);
        }
    }

    public static <V> ITerminableFuture<V> submit(ExecutorService executor, TerminableCallable<V> callable) {
        Future<V> future = executor.submit(callable);
        return new TerminableFuture<V>(future, callable);
    }

    public static <V> ITerminableFuture<V> submit(ExecutorService executor, TerminableCallable.ICallableCleaner<V> callableWithCleaner) {
        return ConcurrencyUtilities.submit(executor, TerminableCallable.create(callableWithCleaner));
    }

    public static <V> ITerminableFuture<V> submit(ExecutorService executor, TerminableCallable.ICallable<V> callable) {
        return ConcurrencyUtilities.submit(executor, TerminableCallable.create(callable));
    }

    public static <V> ITerminableFuture<V> submitAsStoppable(ExecutorService executor, Callable<V> stoppableCallable) {
        return ConcurrencyUtilities.submit(executor, TerminableCallable.createStoppable(stoppableCallable));
    }

    public static void sleep(long millis) throws InterruptedExceptionUnchecked {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new InterruptedExceptionUnchecked(ex);
        }
    }

    public static void join(Thread thread) throws InterruptedExceptionUnchecked {
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            throw new InterruptedExceptionUnchecked(ex);
        }
    }

    public static void join(Thread thread, long millis) throws InterruptedExceptionUnchecked {
        try {
            thread.join(millis);
        }
        catch (InterruptedException ex) {
            throw new InterruptedExceptionUnchecked(ex);
        }
    }

    public static void wait(Object obj) throws InterruptedExceptionUnchecked {
        try {
            obj.wait();
        }
        catch (InterruptedException ex) {
            throw new InterruptedExceptionUnchecked(ex);
        }
    }

    public static void wait(Object obj, long millis) throws InterruptedExceptionUnchecked {
        try {
            obj.wait(millis);
        }
        catch (InterruptedException ex) {
            throw new InterruptedExceptionUnchecked(ex);
        }
    }

    private static long transform(long timeoutMillis) {
        return timeoutMillis < 0L ? Long.MAX_VALUE : timeoutMillis;
    }

    public static interface ICancellationNotifier {
        public void willCancel();
    }

    public static interface ILogSettings {
        public ISimpleLogger getLogger();

        public String getOperationName();

        public LogLevel getLogLevelForError();

        public LogLevel getLogLevelForSuccess();
    }
}

