/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.concurrent.ITimerTaskListener;
import ch.systemsx.cisd.common.concurrent.ITimerTaskStatusProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TimerTask;

public class TimerTaskWithListeners
extends TimerTask {
    private final TimerTask timerTask;
    private final ITimerTaskStatusProvider statusProviderOrNull;
    private final Set<ITimerTaskListener> listeners = new LinkedHashSet<ITimerTaskListener>();

    public TimerTaskWithListeners(TimerTask timerTask) {
        if (timerTask == null) {
            throw new IllegalArgumentException("Unspecified timer task.");
        }
        this.timerTask = timerTask;
        this.statusProviderOrNull = timerTask instanceof ITimerTaskStatusProvider ? (ITimerTaskStatusProvider)((Object)timerTask) : null;
    }

    public void addListener(ITimerTaskListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Unspecified timer task listener.");
        }
        this.listeners.add(listener);
    }

    @Override
    public void run() {
        for (ITimerTaskListener listener : this.listeners) {
            listener.startRunning();
        }
        try {
            this.timerTask.run();
        }
        finally {
            for (ITimerTaskListener listener : this.listeners) {
                listener.finishRunning(this.statusProviderOrNull);
            }
        }
    }

    @Override
    public boolean cancel() {
        for (ITimerTaskListener listener : this.listeners) {
            listener.canceling();
        }
        return this.timerTask.cancel();
    }

    @Override
    public long scheduledExecutionTime() {
        return this.timerTask.scheduledExecutionTime();
    }
}

