/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public class IOUtilities {
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int getChecksumCRC32(InputStream inputStream) {
        return IOUtilities.copyAndGetChecksumCRC32(inputStream, (OutputStream)new NullOutputStream());
    }

    public static int copyAndGetChecksumCRC32(InputStream inputStream, OutputStream out) {
        CRC32 checksummer = new CRC32();
        CheckedInputStream in = new CheckedInputStream(inputStream, checksummer);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        return (int)checksummer.getValue();
    }

    public static String crc32ToString(int checksum) {
        char[] buf = new char[8];
        int w = checksum;
        int x = 7;
        for (int i = 0; i < 4; ++i) {
            buf[x--] = HEX_CHARACTERS[w & 0xF];
            buf[x--] = HEX_CHARACTERS[w >>> 4 & 0xF];
            w >>= 8;
        }
        return new String(buf);
    }
}

