/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MonitoredIOStreamCopier {
    private int bufferSize;
    private ISimpleLogger logger;
    private ITimeProvider timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
    private Statistics readStatistics;
    private Statistics writeStatistics;
    private LinkedBlockingQueue<WritingItem> queue;
    private Throwable writingException;
    private Thread writingThread;

    public MonitoredIOStreamCopier(int bufferSize) {
        this(bufferSize, null);
    }

    public MonitoredIOStreamCopier(int bufferSize, Long maxQueueSizeInBytes) {
        this.bufferSize = bufferSize;
        if (maxQueueSizeInBytes != null) {
            long maxQueueSize = maxQueueSizeInBytes / (long)bufferSize;
            if (maxQueueSize < 1L) {
                throw new ConfigurationFailureException("Maximum queue size " + maxQueueSizeInBytes + " should be larger than buffer size " + bufferSize + ".");
            }
            this.queue = new LinkedBlockingQueue((int)maxQueueSize);
        }
    }

    public void setLogger(ISimpleLogger logger) {
        this.logger = logger;
        if (logger != null) {
            this.readStatistics = new Statistics(this.bufferSize);
            this.writeStatistics = new Statistics(this.bufferSize);
        }
    }

    void setTimeProvider(ITimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public long copy(InputStream input, OutputStream output) {
        long totalNumberOfBytes = 0L;
        try {
            this.startWritingThread();
            int numberOfBytes = 0;
            byte[] buffer = new byte[this.bufferSize];
            while (-1 != (numberOfBytes = this.readBytes(input, buffer))) {
                this.writeBytes(output, numberOfBytes, buffer);
                totalNumberOfBytes += (long)numberOfBytes;
                buffer = new byte[this.bufferSize];
            }
            this.waitOnFinished();
            return totalNumberOfBytes;
        }
        catch (Throwable ex) {
            throw new EnvironmentFailureException("Error after " + totalNumberOfBytes + " bytes copied: " + ex, ex);
        }
    }

    public void close() {
        if (this.logger != null) {
            this.logger.log(LogLevel.INFO, "Reading statistics for input stream: " + this.readStatistics);
            this.logger.log(LogLevel.INFO, "Writing statistics for output stream: " + this.writeStatistics);
        }
    }

    private int readBytes(InputStream input, byte[] buffer) throws IOException {
        long t0 = this.startIO();
        int numberOfBytes = input.read(buffer);
        this.recordTime(numberOfBytes, t0, this.readStatistics);
        return numberOfBytes;
    }

    private void writeBytes(OutputStream output, int numberOfBytes, byte[] buffer) throws Throwable {
        WritingItem writingItem = new WritingItem(output, buffer, numberOfBytes);
        if (this.queue == null) {
            writingItem.write();
        } else {
            this.addToQueue(writingItem);
        }
    }

    private void startWritingThread() {
        if (this.queue == null) {
            return;
        }
        this.writingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        WritingItem writingItem;
                        while ((writingItem = (WritingItem)MonitoredIOStreamCopier.this.queue.take()).data != null) {
                            writingItem.write();
                        }
                    }
                    catch (InterruptedException writingItem) {
                        continue;
                    }
                    catch (Throwable ex) {
                        MonitoredIOStreamCopier.this.writingException = ex;
                    }
                    break;
                }
            }
        });
        this.writingThread.start();
    }

    private void waitOnFinished() throws Throwable {
        if (this.queue == null) {
            return;
        }
        this.addToQueue(new WritingItem(null, null, 0));
        try {
            this.writingThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.writingException != null) {
            throw this.writingException;
        }
    }

    private void addToQueue(WritingItem writingItem) throws Throwable {
        try {
            if (this.writingException != null) {
                throw this.writingException;
            }
            int timeout = 60;
            boolean successful = this.queue.offer(writingItem, timeout, TimeUnit.SECONDS);
            if (!successful) {
                if (this.writingException != null) {
                    throw this.writingException;
                }
                throw new EnvironmentFailureException("Writing item couldn't be added. Time out " + timeout + " sec.");
            }
        }
        catch (InterruptedException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private long startIO() {
        return this.logger != null ? this.timeProvider.getTimeInMilliseconds() : -1L;
    }

    private void recordTime(int numberOfBytes, long t0, Statistics statistics) {
        if (this.logger != null) {
            statistics.add(numberOfBytes, t0, this.timeProvider.getTimeInMilliseconds());
        }
    }

    private static final class NumberOfBytesAndIOTime {
        private int numberOfBytes;
        private long ioTime;

        NumberOfBytesAndIOTime(int numberOfBytes, long ioTime) {
            this.numberOfBytes = numberOfBytes;
            this.ioTime = ioTime;
        }
    }

    private static final class Statistics {
        private final List<NumberOfBytesAndIOTime> data = new ArrayList<NumberOfBytesAndIOTime>();
        private final int minNumberOfBytes;

        public Statistics(int minNumberOfBytes) {
            this.minNumberOfBytes = minNumberOfBytes;
        }

        void add(int numberOfBytes, long startTime, long endTime) {
            if (numberOfBytes > 0) {
                this.data.add(new NumberOfBytesAndIOTime(numberOfBytes, endTime - startTime));
            }
        }

        public String toString() {
            ArrayList<Double> speed = new ArrayList<Double>(this.data.size());
            long totalNumberOfBytes = 0L;
            long totalTime = 0L;
            for (NumberOfBytesAndIOTime nt : this.data) {
                totalNumberOfBytes += (long)nt.numberOfBytes;
                totalTime += nt.ioTime;
                if (nt.numberOfBytes < this.minNumberOfBytes || nt.ioTime <= 0L) continue;
                speed.add(1000.0 * (double)nt.numberOfBytes / (double)nt.ioTime);
            }
            String medianSpeedInfo = "";
            if (!speed.isEmpty()) {
                long medianBytesPerSecond = Math.round(this.calculateMedian(speed));
                medianSpeedInfo = " Median speed: " + FileUtilities.byteCountToDisplaySize(medianBytesPerSecond) + "/sec.";
            }
            String averageSpeedInfo = "";
            if (totalNumberOfBytes >= (long)this.minNumberOfBytes && totalTime > 0L) {
                long averageBytesPerSecond = Math.round(1000.0 * (double)totalNumberOfBytes / (double)totalTime);
                averageSpeedInfo = " Average speed: " + FileUtilities.byteCountToDisplaySize(averageBytesPerSecond) + "/sec.";
            }
            return FileUtilities.byteCountToDisplaySize(totalNumberOfBytes) + " in " + this.data.size() + " chunks took " + DateTimeUtils.renderDuration(totalTime) + "." + averageSpeedInfo + medianSpeedInfo;
        }

        private double calculateMedian(List<Double> speed) {
            Collections.sort(speed);
            int size = speed.size();
            double medianSpeed = speed.get(size / 2);
            if (size % 2 == 0) {
                medianSpeed = 0.5 * (speed.get(size / 2 - 1) + speed.get(size / 2));
            }
            return medianSpeed;
        }
    }

    private final class WritingItem {
        private OutputStream output;
        private byte[] data;
        private int numberOfBytes;

        public WritingItem(OutputStream output, byte[] data, int numberOfBytes) {
            this.output = output;
            this.data = data;
            this.numberOfBytes = numberOfBytes;
        }

        public void write() throws IOException {
            long t0 = MonitoredIOStreamCopier.this.startIO();
            this.output.write(this.data, 0, this.numberOfBytes);
            MonitoredIOStreamCopier.this.recordTime(this.numberOfBytes, t0, MonitoredIOStreamCopier.this.writeStatistics);
        }
    }
}

