/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.properties;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class ExtendedProperties
extends Properties {
    private static final String PATH_DELIMITER = ".";
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_SEPARATOR = ", ";
    private static final String SUFFIX = "}";
    private static final String DEFAULT_VALUE_DELIM = ":";
    private static final String PREFIX = "${";
    private static final int MIN_LENGTH = "${".length() + "}".length() + 1;

    public static ExtendedProperties createWith(Properties properties) {
        assert (properties != null) : "Unspecified properties.";
        ExtendedProperties result = new ExtendedProperties();
        result.putAll((Map<?, ?>)properties);
        return result;
    }

    public static ExtendedProperties getSubset(Properties properties, String prefix, boolean dropPrefix) {
        return ExtendedProperties.createWith(properties).getSubset(prefix, dropPrefix);
    }

    public final ExtendedProperties getSubset(String prefix, boolean dropPrefix) {
        assert (prefix != null) : "Missing prefix";
        return this.getSubset(prefix, dropPrefix, new HashSet<String>());
    }

    private ExtendedProperties getSubset(String prefix, boolean dropPrefix, Set<String> keys) {
        String key;
        ExtendedProperties result = new ExtendedProperties();
        int prefixLength = prefix.length();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement().toString();
            if (!key.startsWith(prefix) || !key.endsWith(PATH_DELIMITER)) continue;
            this.assertNoCyclicDependency(keys, key);
            keys.add(key);
            String inheritTree = super.getProperty(key);
            for (Map.Entry<Object, Object> entry : this.getSubset(inheritTree, true, keys).entrySet()) {
                String newKey = key.substring(0, key.length()) + entry.getKey();
                result.put(this.createKey(newKey, dropPrefix, prefixLength), entry.getValue());
            }
            keys.remove(key);
        }
        enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement().toString();
            if (!key.startsWith(prefix) || key.endsWith(PATH_DELIMITER)) continue;
            result.put(this.createKey(key, dropPrefix, prefixLength), this.getProperty(key));
        }
        return result;
    }

    private String createKey(String key, boolean dropPrefix, int prefixLength) {
        return dropPrefix ? key.substring(prefixLength) : key;
    }

    public void removeSubset(String prefix) {
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            if (!key.startsWith(prefix)) continue;
            this.remove(key);
        }
    }

    private final String expandValue(String key, String value, Set<String> keys) {
        if (value == null || value.length() < MIN_LENGTH) {
            return value;
        }
        StringBuilder result = new StringBuilder(value.length());
        result.append(value);
        int startName = result.indexOf(PREFIX);
        int prefixLen = PREFIX.length();
        int endName = result.indexOf(SUFFIX, startName + prefixLen);
        int suffixLen = SUFFIX.length();
        while (startName >= 0 && endName > startName) {
            String paramName = result.substring(startName + prefixLen, endName);
            String paramValue = null;
            int indexOfDefaultValueDelim = paramName.indexOf(DEFAULT_VALUE_DELIM);
            if (indexOfDefaultValueDelim > 0) {
                paramValue = paramName.substring(indexOfDefaultValueDelim + 1);
                paramName = paramName.substring(0, indexOfDefaultValueDelim);
            }
            if (!keys.contains(paramName)) {
                keys.add(key);
                String propertyValue = this.getProperty(paramName, keys);
                if (propertyValue != null) {
                    paramValue = propertyValue;
                }
                keys.remove(key);
            }
            if (paramValue != null) {
                result.replace(startName, endName + suffixLen, paramValue);
                startName += paramValue.length();
            } else {
                startName = endName + suffixLen;
            }
            startName = result.indexOf(PREFIX, startName);
            endName = result.indexOf(SUFFIX, startName + prefixLen);
        }
        return result.toString();
    }

    public final String getUnalteredProperty(String key) {
        return (String)this.get(key);
    }

    @Override
    public final String getProperty(String key) {
        return this.getProperty(key, new HashSet<String>());
    }

    private String getProperty(String key, Set<String> keys) {
        String result = super.getProperty(key);
        if (result == null) {
            int index = key.length();
            while (index > 0) {
                String newPath;
                int lastIndexOfPathDelimiter = key.lastIndexOf(PATH_DELIMITER, index);
                if (lastIndexOfPathDelimiter >= 0 && (newPath = super.getProperty(key.substring(0, lastIndexOfPathDelimiter + 1))) != null) {
                    this.assertNoCyclicDependency(keys, key);
                    keys.add(key);
                    String newKey = newPath + key.substring(lastIndexOfPathDelimiter + 1);
                    result = this.getProperty(newKey, keys);
                    keys.remove(key);
                    break;
                }
                index = lastIndexOfPathDelimiter - 1;
            }
        }
        return result == null ? null : this.expandValue(key, result, keys);
    }

    private void assertNoCyclicDependency(Set<String> keys, String key) {
        if (keys.contains(key)) {
            throw new IllegalArgumentException("Cyclic definition of property '" + key + "'.");
        }
    }

    @Override
    public final String getProperty(String key, String defaultValue) {
        String result = this.getProperty(key);
        return result == null ? defaultValue : result;
    }

    @Override
    public final synchronized String toString() {
        return StringUtils.replace((String)super.toString(), (String)PROPERTY_SEPARATOR, (String)SystemUtils.LINE_SEPARATOR);
    }
}

