/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

public class VersionUtils {
    public static boolean isCompatible(String requiredVersion, String actualVersion, boolean backward) {
        if (requiredVersion.equals(actualVersion)) {
            return true;
        }
        return new Version(requiredVersion).isCompatible(new Version(actualVersion), backward);
    }

    private static final class Version {
        private final Integer[] version = new Integer[4];

        Version(String versionAsString) {
            String[] versions = versionAsString.split("\\.");
            for (int i = 0; i < versions.length; ++i) {
                this.version[i] = new Integer(versions[i]);
            }
        }

        boolean isCompatible(Version actualVersion, boolean backward) {
            for (int i = 0; i < this.version.length; ++i) {
                Integer requiredVersionLevel = this.version[i];
                if (requiredVersionLevel == null) {
                    return true;
                }
                Integer actualVersionLevel = actualVersion.version[i];
                if (actualVersionLevel == null) {
                    return false;
                }
                if (requiredVersionLevel > actualVersionLevel) {
                    return false;
                }
                if (requiredVersionLevel >= actualVersionLevel) continue;
                return backward;
            }
            return true;
        }
    }
}

