/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.converter;

import ch.systemsx.cisd.common.converter.Converter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class DateConverter
implements Converter<Date> {
    private final SimpleDateFormat dateFormat;

    public DateConverter(String datePattern) {
        assert (datePattern != null);
        this.dateFormat = DateConverter.createDateFormat(datePattern);
    }

    private static final SimpleDateFormat createDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    @Override
    public final Date convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Override
    public final Date getDefaultValue() {
        return new Date();
    }
}

