/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.db.mapper;

import ch.systemsx.cisd.common.db.mapper.AbstractSQLArray;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.sql.SQLException;
import java.util.Set;

class SimpleSQLLongArray
extends AbstractSQLArray {
    private final long[] value;

    SimpleSQLLongArray(long[] array) {
        this.value = array;
    }

    SimpleSQLLongArray(Set<Long> set) {
        if (set instanceof LongSet) {
            this.value = ((LongSet)set).toLongArray();
        } else {
            this.value = new long[set.size()];
            int idx = 0;
            for (Long l : set) {
                this.value[idx++] = l;
            }
        }
    }

    @Override
    public Object getArray() {
        return this.value;
    }

    @Override
    public int getBaseType() {
        return -5;
    }

    @Override
    public String getBaseTypeName() {
        return "int8";
    }

    @Override
    public void free() throws SQLException {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (long v : this.value) {
            builder.append(Long.toString(v));
            builder.append(',');
        }
        if (this.value.length > 0) {
            builder.setLength(builder.length() - 1);
        }
        builder.append('}');
        return builder.toString();
    }
}

