/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.fileconverter.AbstractExecutableFileConverter;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessResult;
import java.util.Collections;
import org.apache.log4j.Logger;

abstract class AbstractImageMagickConvertImageFileConverter
extends AbstractExecutableFileConverter {
    private final String imageMagickVersionOrNull = this.getExecutablePath().startsWith("? ") ? null : this.tryGetImageMagickVersion();

    protected AbstractImageMagickConvertImageFileConverter(Logger machineLog, Logger operationLog) {
        super(machineLog, operationLog);
    }

    private static String tryExtractImageMagickVersion(String imageMagickVersionLine) {
        if (!imageMagickVersionLine.startsWith("Version: ImageMagick")) {
            return null;
        }
        String[] versionStringParts = imageMagickVersionLine.split("\\s+");
        if (versionStringParts.length < 3) {
            return null;
        }
        return versionStringParts[2];
    }

    private String tryGetImageMagickVersion() {
        ProcessResult result = this.runExecutable(Collections.singletonList("--version"));
        ProcessExecutionHelper.log((ProcessResult)result);
        String versionString = AbstractImageMagickConvertImageFileConverter.tryExtractImageMagickVersion((String)result.getOutput().get(0));
        return versionString;
    }

    @Override
    public boolean isAvailable() {
        if (this.imageMagickVersionOrNull == null) {
            return false;
        }
        String[] imageMagickVersionParts = this.imageMagickVersionOrNull.split("\\.");
        if (imageMagickVersionParts.length != 3) {
            return false;
        }
        int imageMagickMajorVersion = Integer.parseInt(imageMagickVersionParts[0]);
        int imageMagickMinorVersion = Integer.parseInt(imageMagickVersionParts[1]);
        return imageMagickMajorVersion >= 6 && imageMagickMinorVersion >= 2;
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        super.check();
        if (!this.isAvailable()) {
            if (this.imageMagickVersionOrNull == null) {
                throw new ConfigurationFailureException("Invalid convert utility.");
            }
            throw ConfigurationFailureException.fromTemplate((String)"Convert utility is too old (expected: v6.2 or newer, found: v%s)", (Object[])new Object[]{this.imageMagickVersionOrNull});
        }
        if (this.machineLog.isInfoEnabled()) {
            this.machineLog.info((Object)String.format("Using convert executable '%s', ImageMagick version %s", this.getExecutablePath(), this.imageMagickVersionOrNull));
        }
    }

    @Override
    protected String getExecutableName() {
        return "convert";
    }
}

