/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.systemsx.cisd.common.fileconverter.AbstractImageMagickConvertImageFileConverter;
import ch.systemsx.cisd.common.fileconverter.IFileConversionMethod;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

class ImageMagickTiffCompressionConverter
extends AbstractImageMagickConvertImageFileConverter {
    private static final String DEFAULT_COMPRESSION_TYPE = "LZW";
    private final String compressionAlgorithm;

    public ImageMagickTiffCompressionConverter() {
        this(DEFAULT_COMPRESSION_TYPE);
    }

    public ImageMagickTiffCompressionConverter(String compressionAlgorithmOrNull) {
        super(LogFactory.getLogger((LogCategory)LogCategory.MACHINE, ImageMagickTiffCompressionConverter.class), LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ImageMagickTiffCompressionConverter.class));
        this.compressionAlgorithm = compressionAlgorithmOrNull == null ? DEFAULT_COMPRESSION_TYPE : compressionAlgorithmOrNull;
    }

    @Override
    protected List<String> getCommandLine(File inFile, File outFile) {
        String compression = StringUtils.isEmpty((CharSequence)this.compressionAlgorithm) ? DEFAULT_COMPRESSION_TYPE : this.compressionAlgorithm;
        return Arrays.asList(inFile.getAbsolutePath(), "-compress", compression, outFile.getAbsolutePath());
    }

    public File tryCheckConvert(File inFile) {
        String ext = FilenameUtils.getExtension((String)inFile.getName()).toLowerCase();
        if ("tiff".equals(ext) || "tif".equals(ext)) {
            return inFile;
        }
        return null;
    }

    public boolean deleteOriginalFile() {
        return false;
    }

    public IFileConversionMethod getConverter() {
        return this;
    }
}

