/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.systemsx.cisd.common.fileconverter.AbstractTiffCpImageFileConverter;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.Arrays;
import java.util.List;

class TiffCpTiffCompressionConverter
extends AbstractTiffCpImageFileConverter {
    private static final String DEFAULT_COMPRESSION_TYPE = "lzw:2";
    private final String compressionType;

    public TiffCpTiffCompressionConverter() {
        this(DEFAULT_COMPRESSION_TYPE);
    }

    public TiffCpTiffCompressionConverter(String compressionTypeOrNull) {
        super(LogFactory.getLogger((LogCategory)LogCategory.MACHINE, TiffCpTiffCompressionConverter.class), LogFactory.getLogger((LogCategory)LogCategory.OPERATION, TiffCpTiffCompressionConverter.class));
        this.compressionType = compressionTypeOrNull == null ? DEFAULT_COMPRESSION_TYPE : compressionTypeOrNull;
    }

    @Override
    protected List<String> getCommandLine(File inFile, File outFile) {
        return Arrays.asList("-c", this.compressionType, inFile.getAbsolutePath(), outFile.getAbsolutePath());
    }
}

