/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.filesystem.DirectoryScanningTimerTask;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.StoreItem;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public final class DirectoryScannedStore
implements DirectoryScanningTimerTask.IScannedStore {
    private final FileFilter filter;
    private final File directory;

    DirectoryScannedStore(FileFilter filter, File directory) {
        assert (directory != null) : "Directory not specified";
        assert (filter != null) : "File filter not specified";
        this.filter = filter;
        this.directory = directory;
    }

    @Override
    public final String getLocationDescription(StoreItem item) {
        return this.asFile(item).getPath();
    }

    @Override
    public final File asFile(StoreItem item) {
        return StoreItem.asFile(this.directory, item);
    }

    @Override
    public StoreItem asStoreItem(String locationDescription) {
        return new StoreItem(FilenameUtils.getName((String)locationDescription));
    }

    @Override
    public final boolean existsOrError(StoreItem item) {
        return this.asFile(item).exists();
    }

    @Override
    public StoreItem[] tryListSorted(ISimpleLogger loggerOrNull) {
        File[] files = FileUtilities.tryListFiles((File)this.directory, null, (ISimpleLogger)loggerOrNull);
        if (files != null) {
            FileUtilities.sortByLastModified((File[])files);
            return StoreItem.asItems(files);
        }
        return null;
    }

    @Override
    public StoreItem[] tryFilterReadyToProcess(StoreItem[] items, ISimpleLogger loggerOrNull) {
        StoreItem currentItem = null;
        try {
            ArrayList<StoreItem> result = new ArrayList<StoreItem>(items.length);
            StoreItem[] storeItemArray = items;
            int n = storeItemArray.length;
            for (int i = 0; i < n; ++i) {
                StoreItem item;
                currentItem = item = storeItemArray[i];
                if (!this.filter.accept(new File(this.directory, item.getName()))) continue;
                result.add(item);
            }
            return result.toArray(new StoreItem[result.size()]);
        }
        catch (RuntimeException ex) {
            if (loggerOrNull != null) {
                String message = String.format("Failed to filter store items for processing: filter '%s' threw exception %s (message: \"%s\") on item '%s'", StringUtils.defaultIfEmpty((CharSequence)this.filter.getClass().getSimpleName(), (CharSequence)"UNKNOWN"), ex.getClass().getSimpleName(), StringUtils.defaultIfEmpty((CharSequence)ex.getMessage(), (CharSequence)"-"), currentItem);
                loggerOrNull.log(LogLevel.ERROR, message);
                loggerOrNull.log(LogLevel.ERROR, message, (Throwable)ex);
            }
            return null;
        }
    }

    public final String toString() {
        return this.directory.toString();
    }
}

