/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.exceptions.StatusWithResult;
import ch.systemsx.cisd.common.exceptions.UnknownLastChangedException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.ILastModificationChecker;
import ch.systemsx.cisd.common.filesystem.StoreItem;
import java.io.File;

public class LastModificationChecker
implements ILastModificationChecker {
    private final File parentDir;

    public LastModificationChecker(File parentDir) {
        this.parentDir = parentDir;
    }

    @Override
    public final StatusWithResult<Long> lastChanged(StoreItem item, long stopWhenFindYounger) {
        try {
            long lastChanged = FileUtilities.lastChanged((File)this.getChildFile(item), (boolean)true, (long)stopWhenFindYounger);
            return StatusWithResult.create((Object)lastChanged);
        }
        catch (UnknownLastChangedException ex) {
            return LastModificationChecker.createLastChangedError(item, ex);
        }
    }

    @Override
    public final StatusWithResult<Long> lastChangedRelative(StoreItem item, long stopWhenFindYoungerRelative) {
        try {
            long lastChanged = FileUtilities.lastChangedRelative((File)this.getChildFile(item), (boolean)true, (long)stopWhenFindYoungerRelative);
            return StatusWithResult.create((Object)lastChanged);
        }
        catch (UnknownLastChangedException ex) {
            return LastModificationChecker.createLastChangedError(item, ex);
        }
    }

    private static StatusWithResult<Long> createLastChangedError(StoreItem item, UnknownLastChangedException ex) {
        String errorMsg = String.format("Could not determine \"last changed time\" of '%s'.", item);
        return StatusWithResult.createErrorWithResult((String)errorMsg);
    }

    protected final File getChildFile(StoreItem item) {
        return new File(this.parentDir, item.getName());
    }
}

