/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.collection.ExtendedLinkedBlockingQueue;
import ch.systemsx.cisd.common.collection.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.IFileRemover;
import ch.systemsx.cisd.common.filesystem.LoggingPathRemoverDecorator;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueDecorator;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.io.QueuePersister;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.time.TimingParameters;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class QueueingPathRemoverService {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, QueueingPathRemoverService.class);
    @Private
    static final String SHREDDER_PREFIX = ".SHREDDER_";
    private static final AtomicInteger counter = new AtomicInteger();
    private static IExtendedBlockingQueue<File> queue = null;
    private static Closeable queueCloseableOrNull = null;
    private static Thread thread = null;
    private static IFileRemover deepRemover = null;
    private static File shredderDir;

    public static final void start() {
        QueueingPathRemoverService.start(null, null);
    }

    public static final void start(File storeRootOrNull, File queueFileOrNull) {
        QueueingPathRemoverService.start(storeRootOrNull, queueFileOrNull, TimingParameters.getDefaultParameters());
    }

    public static final synchronized void start(File storeRootOrNull, File queueFileOrNull, TimingParameters parameters) {
        Log4jSimpleLogger logger = new Log4jSimpleLogger(operationLog);
        IFileOperations monitoringProxy = FileOperations.createMonitoredInstance(parameters);
        deepRemover = new LoggingPathRemoverDecorator(monitoringProxy, (ISimpleLogger)logger, false);
        if (queueFileOrNull != null) {
            PersistentExtendedBlockingQueueDecorator persistentQueue;
            queue = persistentQueue = PersistentExtendedBlockingQueueFactory.createSmartPersist((File)queueFileOrNull);
            queueCloseableOrNull = persistentQueue;
        } else {
            queue = new ExtendedLinkedBlockingQueue();
        }
        if (storeRootOrNull != null && !(shredderDir = new File(storeRootOrNull, ".SHREDDER")).exists()) {
            shredderDir.mkdir();
        }
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        File fileToRemove = (File)queue.peekWait();
                        deepRemover.removeRecursively(fileToRemove);
                        queue.take();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InterruptedExceptionUnchecked interruptedExceptionUnchecked) {
                    // empty catch block
                }
            }
        }, "Shredder Queue");
        thread.setDaemon(true);
        thread.start();
    }

    public static boolean removeRecursively(File fileToRemove) {
        if (!QueueingPathRemoverService.isRunning()) {
            throw new IllegalStateException("Cannot remove the file because the shreder is already stopped: " + fileToRemove);
        }
        if (fileToRemove.isFile()) {
            return fileToRemove.delete();
        }
        String name = SHREDDER_PREFIX + System.currentTimeMillis() + "-" + counter.incrementAndGet() + "-" + fileToRemove.getName();
        File shredderFile = shredderDir != null ? new File(shredderDir, name) : new File(fileToRemove.getParentFile(), name);
        boolean ok = fileToRemove.renameTo(shredderFile);
        if (ok) {
            queue.add((Object)shredderFile);
        }
        return ok;
    }

    private static final void close() {
        if (queueCloseableOrNull != null) {
            try {
                queueCloseableOrNull.close();
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
    }

    public static final synchronized void stop() {
        if (thread == null) {
            return;
        }
        thread.interrupt();
        QueueingPathRemoverService.close();
        thread = null;
        queue = null;
        queueCloseableOrNull = null;
        deepRemover = null;
    }

    public static final synchronized boolean stopAndWait(long timeoutMillis) {
        if (thread == null) {
            return true;
        }
        thread.interrupt();
        try {
            thread.join(timeoutMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        QueueingPathRemoverService.close();
        boolean ok = !thread.isAlive();
        thread = null;
        queue = null;
        queueCloseableOrNull = null;
        deepRemover = null;
        return ok;
    }

    public static final synchronized boolean isRunning() {
        return deepRemover != null;
    }

    public static final List<File> listShredderItems(File queueFile) {
        return QueuePersister.list(File.class, (File)queueFile);
    }

    private QueueingPathRemoverService() {
    }
}

