/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ResultStatus<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final T result;
    private final boolean errorOccurred;
    private final String messageOrNull;

    public static <T> ResultStatus<T> createError() {
        return new ResultStatus<Object>(null, true, null);
    }

    public static <T> ResultStatus<T> createError(String message) {
        return new ResultStatus<Object>(null, true, message);
    }

    public static <T> ResultStatus<T> createResult(T result) {
        return new ResultStatus<T>(result, false, null);
    }

    public static <T> ResultStatus<T> createResult(T result, String message) {
        return new ResultStatus<T>(result, false, message);
    }

    protected ResultStatus(T result, boolean errorOccurred, String messageOrNull) {
        this.result = result;
        this.errorOccurred = errorOccurred;
        this.messageOrNull = messageOrNull;
    }

    public final T getResult() {
        assert (!this.isError()) : "Operation failed, there is no result";
        return this.result;
    }

    public final String tryGetMessage() {
        return this.messageOrNull;
    }

    public final boolean isError() {
        return this.errorOccurred;
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }
}

