/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.highwatermark;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.highwatermark.HighwaterMarkWatcher;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public final class HostAwareFileWithHighwaterMark
extends HostAwareFile {
    private static final long serialVersionUID = 1L;
    static final String SEP = "-";
    public static final int DEFAULT_HIGHWATER_MARK = -1;
    public static final String HIGHWATER_MARK_PROPERTY_KEY = "highwater-mark";
    private final long highwaterMarkInKb;

    public HostAwareFileWithHighwaterMark(String hostOrNull, String path, String rsyncModuleOrNull, long highwaterMarkInKb) {
        super(hostOrNull, path, rsyncModuleOrNull);
        this.highwaterMarkInKb = highwaterMarkInKb;
    }

    public HostAwareFileWithHighwaterMark(String path, long highwaterMarkInKb) {
        this(null, path, null, highwaterMarkInKb);
    }

    public HostAwareFileWithHighwaterMark(String path) {
        this(path, -1L);
    }

    public HostAwareFileWithHighwaterMark(String hostOrNull, String path, String rsyncModuleOrNull) {
        this(hostOrNull, path, rsyncModuleOrNull, -1L);
    }

    public static final HostAwareFileWithHighwaterMark fromProperties(Properties properties, String hostFilePropertyKey) throws ConfigurationFailureException {
        assert (properties != null) : "Unspecified properties";
        assert (StringUtils.isNotBlank((CharSequence)hostFilePropertyKey)) : "Host-file property key is blank";
        String hostFile = PropertyUtils.getMandatoryProperty((Properties)properties, (String)hostFilePropertyKey);
        long highwaterMarkInKb = PropertyUtils.getLong((Properties)properties, (String)hostFilePropertyKey.concat(SEP).concat(HIGHWATER_MARK_PROPERTY_KEY), (long)-1L);
        return HostAwareFileWithHighwaterMark.create(hostFile, highwaterMarkInKb);
    }

    public static HostAwareFileWithHighwaterMark create(String hostFile, long highwaterMarkInKb) {
        String path;
        String rsyncModuleOrNull;
        String hostNameOrNull = null;
        int index = HostAwareFileWithHighwaterMark.getHostFileIndex(hostFile);
        if (index > -1) {
            hostNameOrNull = hostFile.substring(0, index);
            int index2 = hostFile.indexOf(58, index + 1);
            if (index2 > -1) {
                rsyncModuleOrNull = hostFile.substring(index + 1, index2);
                path = hostFile.substring(index2 + 1);
            } else {
                rsyncModuleOrNull = null;
                path = hostFile.substring(index + 1);
            }
        } else {
            rsyncModuleOrNull = null;
            path = HostAwareFileWithHighwaterMark.getCanonicalFile(hostFile);
        }
        return new HostAwareFileWithHighwaterMark(hostNameOrNull, path, rsyncModuleOrNull, highwaterMarkInKb);
    }

    private static String getCanonicalFile(String hostFile) {
        File file = new File(hostFile);
        try {
            return file.getCanonicalFile().getPath();
        }
        catch (IOException ex) {
            throw new ConfigurationFailureException("Unknown file " + file.getAbsolutePath(), (Throwable)ex);
        }
    }

    public final long getHighwaterMark() {
        return this.highwaterMarkInKb;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.getPathDescription());
        builder.append(" ").append(String.format("[high water mark: %s]", HighwaterMarkWatcher.displayKilobyteValue(this.getHighwaterMark())));
        return builder.toString();
    }
}

