/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.rsync;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.action.ITerminable;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.common.filesystem.CopyModeExisting;
import ch.systemsx.cisd.common.filesystem.IDirectoryImmutableCopier;
import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncExitValueTranslator;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncVersionChecker;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.IProcessHandler;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.utilities.ITextHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class RsyncCopier
implements IPathCopier,
IDirectoryImmutableCopier {
    private static final Logger machineLog = LogFactory.getLogger((LogCategory)LogCategory.MACHINE, RsyncCopier.class);
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, RsyncCopier.class);
    @Private
    static final Status TERMINATED_STATUS = Status.createRetriableError((String)"Process was terminated.");
    private static final Status INTERRUPTED_STATUS = Status.createRetriableError((String)"Process was interrupted.");
    private static final Status TIMEOUT_STATUS = Status.createRetriableError((String)"Process has stopped because of timeout.");
    private final String rsyncExecutable;
    private Map<String, RsyncRecord> remoteHostRsyncMap = new HashMap<String, RsyncRecord>();
    private final RsyncVersionChecker.RsyncVersion rsyncVersion;
    private final String sshExecutablePathOrNull;
    private final List<String> additionalCmdLineFlagsOrNull;
    private final List<String> cmdLineFlagsOrNull;
    private final boolean overwriteMode;
    private final boolean destinationDirectoryRequiresDeletionBeforeCreation;
    private final AtomicReference<ITerminable> rsyncTerminator;

    public RsyncCopier(File rsyncExecutable) {
        this(rsyncExecutable, null, false, false, new String[0]);
    }

    public RsyncCopier(File rsyncExecutable, String ... cmdLineFlags) {
        this(rsyncExecutable, null, false, false, cmdLineFlags);
    }

    public RsyncCopier(File rsyncExecutable, File sshExecutableOrNull, String ... cmdLineFlags) {
        if (rsyncExecutable == null) {
            throw new ConfigurationFailureException("No rsync executable available.");
        }
        if (!rsyncExecutable.exists()) {
            throw new ConfigurationFailureException("rsync executable '" + rsyncExecutable + "' does not exist.");
        }
        this.rsyncExecutable = rsyncExecutable.getAbsolutePath();
        this.rsyncVersion = RsyncVersionChecker.getVersion(rsyncExecutable.getAbsolutePath());
        this.sshExecutablePathOrNull = sshExecutableOrNull != null ? sshExecutableOrNull.getPath() : null;
        this.rsyncTerminator = new AtomicReference<Object>(null);
        this.overwriteMode = false;
        this.destinationDirectoryRequiresDeletionBeforeCreation = false;
        this.additionalCmdLineFlagsOrNull = null;
        this.cmdLineFlagsOrNull = Arrays.asList(cmdLineFlags);
    }

    public RsyncCopier(File rsyncExecutable, File sshExecutableOrNull, boolean destinationDirectoryRequiresDeletionBeforeCreation, boolean overwrite, String ... cmdLineFlags) {
        if (rsyncExecutable == null) {
            throw new ConfigurationFailureException("No rsync executable available.");
        }
        if (!rsyncExecutable.exists()) {
            throw new ConfigurationFailureException("rsync executable '" + rsyncExecutable + "' does not exist.");
        }
        this.rsyncExecutable = rsyncExecutable.getAbsolutePath();
        this.rsyncVersion = RsyncVersionChecker.getVersion(rsyncExecutable.getAbsolutePath());
        this.sshExecutablePathOrNull = sshExecutableOrNull != null ? sshExecutableOrNull.getPath() : null;
        this.destinationDirectoryRequiresDeletionBeforeCreation = destinationDirectoryRequiresDeletionBeforeCreation;
        this.overwriteMode = overwrite;
        this.rsyncTerminator = new AtomicReference<Object>(null);
        this.additionalCmdLineFlagsOrNull = cmdLineFlags.length > 0 ? Arrays.asList(cmdLineFlags) : null;
        this.cmdLineFlagsOrNull = null;
    }

    private boolean rsyncSupportsAppend(RsyncVersionChecker.RsyncVersion versionOrNull) {
        return versionOrNull == null || versionOrNull.isNewerOrEqual(2, 6, 7);
    }

    private boolean isGoodEnough(RsyncVersionChecker.RsyncVersion versionOrNull) {
        return versionOrNull != null && versionOrNull.isNewerOrEqual(2, 6, 0);
    }

    private boolean isOverwriteMode(RsyncRecord remoteRsyncOrNull) {
        return this.overwriteMode || this.destinationDirectoryRequiresDeletionBeforeCreation || !this.rsyncSupportsAppend(this.rsyncVersion) || remoteRsyncOrNull != null && !this.rsyncSupportsAppend(remoteRsyncOrNull.getRsyncVersion());
    }

    public boolean isProgressEnabled() {
        return this.cmdLineFlagsOrNull != null && this.cmdLineFlagsOrNull.contains("--progress");
    }

    public final Status copy(File sourcePath, File destinationDirectory, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        return this.copy(sourcePath.getAbsolutePath(), null, destinationDirectory.getAbsolutePath(), null, null, null, false, stdoutHandlerOrNull, stderrHandlerOrNull);
    }

    public final Status copyContent(File sourcePath, File destinationDirectory, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        return this.copy(sourcePath.getAbsolutePath(), null, destinationDirectory.getAbsolutePath(), null, null, null, true, stdoutHandlerOrNull, stderrHandlerOrNull);
    }

    public final Status copyFromRemote(String sourcePath, String sourceHost, File destinationDirectory, String rsyncModuleNameOrNull, String rsyncPasswordFileOrNull, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        return this.copy(sourcePath, sourceHost, destinationDirectory.getAbsolutePath(), null, rsyncModuleNameOrNull, rsyncPasswordFileOrNull, false, stdoutHandlerOrNull, stderrHandlerOrNull);
    }

    public Status copyContentFromRemote(String sourcePath, String sourceHost, File destinationDirectory, String rsyncModuleNameOrNull, String rsyncPasswordFileOrNull, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        return this.copy(sourcePath, sourceHost, destinationDirectory.getAbsolutePath(), null, rsyncModuleNameOrNull, rsyncPasswordFileOrNull, true, stdoutHandlerOrNull, stderrHandlerOrNull);
    }

    public final Status copyToRemote(File sourcePath, String destinationDirectory, String destinationHost, String rsyncModuleNameOrNull, String rsyncPasswordFileOrNull, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        return this.copy(sourcePath.getAbsolutePath(), null, destinationDirectory, destinationHost, rsyncModuleNameOrNull, rsyncPasswordFileOrNull, false, stdoutHandlerOrNull, stderrHandlerOrNull);
    }

    public Status copyContentToRemote(File sourcePath, String destinationDirectory, String destinationHostOrNull, String rsyncModuleNameOrNull, String rsyncPasswordFileOrNull, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        return this.copy(sourcePath.getAbsolutePath(), null, destinationDirectory, destinationHostOrNull, rsyncModuleNameOrNull, rsyncPasswordFileOrNull, true, stdoutHandlerOrNull, stderrHandlerOrNull);
    }

    @Override
    public Status copyDirectoryImmutably(File sourceDirectory, File destinationDirectory, String targetNameOrNull) {
        return this.copyDirectoryImmutably(sourceDirectory, destinationDirectory, targetNameOrNull, CopyModeExisting.ERROR);
    }

    @Override
    public Status copyDirectoryImmutably(File sourceDirectory, File destinationDirectory, String targetNameOrNull, CopyModeExisting mode) {
        assert (sourceDirectory != null);
        assert (sourceDirectory.isDirectory()) : sourceDirectory.getAbsolutePath();
        assert (destinationDirectory != null);
        assert (destinationDirectory.isDirectory()) : destinationDirectory.getAbsolutePath();
        File targetDirectory = this.createTargetDirectory(sourceDirectory, destinationDirectory, targetNameOrNull);
        if (mode == CopyModeExisting.ERROR && targetDirectory.exists()) {
            return Status.createError((String)("Target directory '" + targetDirectory + "' already exists."));
        }
        List<String> commandLine = this.createCommandLineForImmutableCopy(sourceDirectory, targetDirectory, mode);
        ProcessResult processResult = this.runCommand(commandLine, -1L, null, null);
        return RsyncCopier.createStatus(processResult);
    }

    private File createTargetDirectory(File sourceDirectory, File destinationDirectory, String targetNameOrNull) {
        if (targetNameOrNull == null) {
            return new File(destinationDirectory, sourceDirectory.getName());
        }
        return new File(destinationDirectory, targetNameOrNull);
    }

    public final synchronized boolean terminate() {
        ITerminable copyProcess = this.rsyncTerminator.get();
        if (copyProcess != null) {
            return copyProcess.terminate();
        }
        return false;
    }

    private final List<String> createCommandLineForImmutableCopy(File sourcePath, File destinationPath, CopyModeExisting mode) {
        assert (sourcePath != null);
        assert (destinationPath != null);
        assert (destinationPath.getParentFile().isDirectory()) : destinationPath.getParentFile().getAbsolutePath();
        String absoluteSource = sourcePath.getAbsolutePath();
        ArrayList<String> commandLineList = new ArrayList<String>();
        commandLineList.add(this.rsyncExecutable);
        commandLineList.add("--archive");
        if (this.additionalCmdLineFlagsOrNull != null) {
            commandLineList.addAll(this.additionalCmdLineFlagsOrNull);
        }
        if (mode == CopyModeExisting.IGNORE) {
            commandLineList.add("--ignore-existing");
        }
        commandLineList.add("--link-dest=" + RsyncCopier.toUnix(absoluteSource));
        commandLineList.add(RsyncCopier.toUnix(absoluteSource) + "/");
        commandLineList.add(RsyncCopier.toUnix(destinationPath.getAbsolutePath()));
        return commandLineList;
    }

    public final void check() {
        if (machineLog.isDebugEnabled()) {
            machineLog.debug((Object)String.format("Testing rsync executable '%s'", this.rsyncExecutable));
        }
        if (this.rsyncVersion == null) {
            if (OSUtilities.executableExists((String)this.rsyncExecutable)) {
                throw new ConfigurationFailureException(String.format("Rsync executable '%s' is invalid.", this.rsyncExecutable));
            }
            throw new ConfigurationFailureException(String.format("Rsync executable '%s' does not exist.", this.rsyncExecutable));
        }
        if (!this.isGoodEnough(this.rsyncVersion)) {
            throw new ConfigurationFailureException(String.format("Rsync executable '%s' is too old (required: 2.6.0, found: %s)", this.rsyncExecutable, this.rsyncVersion.getVersionString()));
        }
        if (machineLog.isInfoEnabled()) {
            machineLog.info((Object)String.format("Using rsync executable '%s', version %s, mode: %s", this.rsyncExecutable, this.rsyncVersion.getVersionString(), this.isOverwriteMode(null) ? "overwrite" : "append"));
        }
        if (this.rsyncVersion.isRsyncPreReleaseVersion()) {
            machineLog.warn((Object)String.format("The rsync executable '%s' is a pre-release version. It is not recommended to use such a version in a production environment.", this.rsyncExecutable));
        }
    }

    public boolean isRemote() {
        return false;
    }

    public boolean checkRsyncConnectionViaRsyncServer(String host, String rsyncModule, String rsyncPasswordFileOrNull, long millisToWaitForCompletion) {
        ArrayList<String> commandLineList = new ArrayList<String>();
        commandLineList.add(this.rsyncExecutable);
        if (rsyncPasswordFileOrNull != null && new File(rsyncPasswordFileOrNull).exists()) {
            commandLineList.add("--password-file");
            commandLineList.add(rsyncPasswordFileOrNull);
        }
        commandLineList.add(RsyncCopier.buildUnixPathForServer(host, "/", rsyncModule, false));
        ProcessResult processResult = this.runCommand(commandLineList, millisToWaitForCompletion, null, null);
        processResult.log();
        return processResult.isOK();
    }

    private static final List<String> createSshCommand(String host, String sshExecutable, String command) {
        ArrayList<String> wrappedCmd = new ArrayList<String>();
        List<String> sshCommand = Arrays.asList(sshExecutable, "-T", host);
        wrappedCmd.addAll(sshCommand);
        wrappedCmd.add(command);
        return wrappedCmd;
    }

    public boolean checkRsyncConnectionViaSsh(String host, String rsyncExecutableOnHostOrNull, long millisToWaitForCompletion) {
        if (this.sshExecutablePathOrNull == null) {
            return false;
        }
        if (this.remoteHostRsyncMap.containsKey(host)) {
            return true;
        }
        String rsyncExec = rsyncExecutableOnHostOrNull == null ? this.tryFindRemoteRsyncExecutable(host, millisToWaitForCompletion) : rsyncExecutableOnHostOrNull;
        if (rsyncExec == null) {
            return false;
        }
        List<String> commandLineList = RsyncCopier.createSshCommand(host, this.sshExecutablePathOrNull, rsyncExec + " --version");
        ProcessResult verResult = this.runCommand(commandLineList, millisToWaitForCompletion, null, null);
        verResult.log();
        if (!verResult.isOK() || verResult.getOutput().size() == 0) {
            return false;
        }
        RsyncVersionChecker.RsyncVersion versionOrNull = RsyncVersionChecker.tryParseVersionLine((String)verResult.getOutput().get(0));
        boolean ok = this.isGoodEnough(versionOrNull);
        if (ok) {
            this.remoteHostRsyncMap.put(host, new RsyncRecord(rsyncExec, versionOrNull));
            if (machineLog.isInfoEnabled()) {
                machineLog.info((Object)String.format("On host '%s': using rsync executable '%s', version %s", host, rsyncExec, ObjectUtils.toString((Object)versionOrNull, (String)"UNKNOWN")));
            }
        } else {
            machineLog.error((Object)String.format("On host '%s': rsync executable '%s', version %s is too old", host, rsyncExec, ObjectUtils.toString((Object)versionOrNull, (String)"UNKNOWN")));
        }
        return ok;
    }

    private String tryFindRemoteRsyncExecutable(String host, long millisToWaitForCompletion) {
        List<String> commandLineList = RsyncCopier.createSshCommand(host, this.sshExecutablePathOrNull, "type -p rsync");
        ProcessResult result = this.runCommand(commandLineList, millisToWaitForCompletion, null, null);
        result.log();
        if (result.isOK() && result.getOutput().size() != 1) {
            if (result.getOutput().size() == 0) {
                machineLog.warn((Object)String.format("No output on command '%s'.", StringUtils.join(commandLineList, (char)' ')));
            } else {
                machineLog.warn((Object)String.format("Unexpected output on command '%s':\n%s", StringUtils.join(commandLineList, (char)' '), StringUtils.join((Iterable)result.getOutput(), (char)'\n')));
            }
        }
        if (result.isOK() && result.getOutput().size() == 1) {
            return (String)result.getOutput().get(0);
        }
        return null;
    }

    private final Status copy(String sourcePath, String sourceHostOrNull, String destinationDirectory, String destinationHostOrNull, String rsyncModuleNameOrNull, String rsyncPasswordFileOrNull, boolean copyDirectoryContent, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        File destinationFile;
        File sourceFile;
        assert (sourcePath != null);
        assert (destinationDirectory != null);
        if (sourceHostOrNull == null && !(sourceFile = new File(sourcePath)).exists()) {
            throw new IOExceptionUnchecked(this.logNonExistent(sourceFile));
        }
        if (destinationHostOrNull == null && !(destinationFile = new File(destinationDirectory)).exists()) {
            throw new IOExceptionUnchecked(this.logNonExistent(destinationFile));
        }
        assert (sourceHostOrNull == null || destinationHostOrNull == null);
        List<String> commandLine = this.createCommandLineForMutableCopy(sourcePath, sourceHostOrNull, destinationDirectory, destinationHostOrNull, rsyncModuleNameOrNull, rsyncPasswordFileOrNull, copyDirectoryContent);
        return RsyncCopier.createStatus(this.runCommand(commandLine, -1L, stdoutHandlerOrNull, stderrHandlerOrNull));
    }

    private final String logNonExistent(File path) {
        if (path == null) {
            return "null";
        }
        return "path '" + path.getAbsolutePath() + "' does not exist";
    }

    @Private
    final List<String> createCommandLineForMutableCopy(String sourcePath, String sourceHostOrNull, String destinationDirectory, String destinationHostOrNull, String rsyncModuleNameOrNull, String rsyncPasswordFileOrNull, boolean copyDirectoryContent) {
        ArrayList<String> commandLineList = new ArrayList<String>();
        RsyncRecord remoteRsyncOrNull = this.tryGetRemoteRsync(sourceHostOrNull, destinationHostOrNull);
        commandLineList.add(this.rsyncExecutable);
        if (this.cmdLineFlagsOrNull != null) {
            commandLineList.addAll(this.cmdLineFlagsOrNull);
        } else {
            List<String> standardParameters = Arrays.asList("--archive", "--delete-before", "--inplace");
            commandLineList.addAll(standardParameters);
            if (this.isOverwriteMode(remoteRsyncOrNull)) {
                commandLineList.add("--whole-file");
            } else {
                commandLineList.add("--append");
            }
        }
        if (this.sshExecutablePathOrNull != null && (destinationHostOrNull != null || sourceHostOrNull != null) && rsyncModuleNameOrNull == null) {
            commandLineList.add("--rsh");
            commandLineList.add(RsyncCopier.getSshExecutableArgument(this.sshExecutablePathOrNull));
            if (remoteRsyncOrNull != null) {
                commandLineList.add("--rsync-path");
                commandLineList.add(remoteRsyncOrNull.getRsyncExecutable());
            }
        }
        if (rsyncModuleNameOrNull != null && rsyncPasswordFileOrNull != null && new File(rsyncPasswordFileOrNull).exists()) {
            commandLineList.add("--password-file");
            commandLineList.add(rsyncPasswordFileOrNull);
        }
        if (this.additionalCmdLineFlagsOrNull != null) {
            commandLineList.addAll(this.additionalCmdLineFlagsOrNull);
        }
        commandLineList.add(RsyncCopier.buildUnixPathForServer(sourceHostOrNull, sourcePath, rsyncModuleNameOrNull, copyDirectoryContent));
        commandLineList.add(RsyncCopier.buildUnixPathForServer(destinationHostOrNull, destinationDirectory, rsyncModuleNameOrNull, true));
        return commandLineList;
    }

    private RsyncRecord tryGetRemoteRsync(String sourceHostOrNull, String destinationHostOrNull) {
        RsyncRecord sourceRemoteRsyncOrNull = sourceHostOrNull == null ? null : this.remoteHostRsyncMap.get(sourceHostOrNull);
        RsyncRecord destinationRemoteRsyncOrNull = destinationHostOrNull == null ? null : this.remoteHostRsyncMap.get(destinationHostOrNull);
        RsyncRecord remoteRsyncOrNull = sourceRemoteRsyncOrNull != null ? sourceRemoteRsyncOrNull : destinationRemoteRsyncOrNull;
        return remoteRsyncOrNull;
    }

    private static final String getSshExecutableArgument(String sshExecutable) {
        return new File(sshExecutable).getAbsolutePath() + " -oBatchMode=yes";
    }

    private static String buildUnixPathForServer(String host, String resource, String rsyncModule, boolean appendSlash) {
        if (null == host) {
            String path = resource;
            if (appendSlash) {
                path = path + File.separator;
            }
            return RsyncCopier.toUnix(path);
        }
        String sep = "::";
        String path = rsyncModule;
        if (path == null) {
            sep = ":";
            path = resource;
        }
        if (appendSlash) {
            path = path + '/';
        }
        return host + sep + path.replace('\\', '/');
    }

    private static String toUnix(String path) {
        if (!OSUtilities.isWindows()) {
            return path;
        }
        String resultPath = path.replace('\\', '/');
        if (resultPath.charAt(1) == ':') {
            resultPath = "/cygdrive/" + resultPath.charAt(0) + resultPath.substring(2);
        }
        return resultPath;
    }

    private static final Status createStatus(ProcessResult processResult) {
        if (processResult.isTerminated()) {
            return TERMINATED_STATUS;
        }
        if (processResult.isInterruped()) {
            return INTERRUPTED_STATUS;
        }
        if (processResult.isTimedOut()) {
            return TIMEOUT_STATUS;
        }
        int exitValue = processResult.getExitValue();
        StatusFlag flag = RsyncExitValueTranslator.getStatus(exitValue);
        if (flag == StatusFlag.OK) {
            return Status.OK;
        }
        boolean retriableError = flag == StatusFlag.RETRIABLE_ERROR;
        return Status.createError((boolean)retriableError, (String)RsyncExitValueTranslator.getMessage(exitValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessResult runCommand(List<String> commandLine, long millisToWaitForCompletion, ITextHandler stdoutHandlerOrNull, ITextHandler stderrHandlerOrNull) {
        IProcessHandler processHandler;
        if (operationLog.isTraceEnabled()) {
            operationLog.trace((Object)String.format("Trying to get lock for running command '%s'", commandLine));
        }
        RsyncCopier rsyncCopier = this;
        synchronized (rsyncCopier) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("Running command '%s'", commandLine));
            }
            processHandler = ProcessExecutionHelper.runNonblocking(commandLine, (Logger)operationLog, (Logger)machineLog, (ProcessIOStrategy)ProcessIOStrategy.DEFAULT_IO_STRATEGY, (ITextHandler)stdoutHandlerOrNull, (ITextHandler)stderrHandlerOrNull);
            this.rsyncTerminator.set((ITerminable)processHandler);
        }
        if (operationLog.isTraceEnabled()) {
            operationLog.trace((Object)String.format("Waiting for process of command '%s' to finish.", commandLine));
        }
        ProcessResult processResult = processHandler.getResult(millisToWaitForCompletion, false);
        processResult.log();
        return processResult;
    }

    private static class RsyncRecord {
        private final String rsyncExecutable;
        private final RsyncVersionChecker.RsyncVersion rsyncVersion;

        RsyncRecord(String rsyncExecutable, RsyncVersionChecker.RsyncVersion rsyncVersion) {
            this.rsyncExecutable = rsyncExecutable;
            this.rsyncVersion = rsyncVersion;
        }

        public final String getRsyncExecutable() {
            return this.rsyncExecutable;
        }

        public final RsyncVersionChecker.RsyncVersion getRsyncVersion() {
            return this.rsyncVersion;
        }
    }
}

