/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.tar;

import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.io.MonitoredIOStreamCopier;
import ch.systemsx.cisd.common.logging.ConsoleLogger;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class Untar
implements Closeable {
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private final TarArchiveInputStream in;
    private final boolean setOwner;
    private final MonitoredIOStreamCopier copier;

    public Untar(File tarFile) throws FileNotFoundException {
        this(tarFile, 131072);
    }

    public Untar(File tarFile, int bufferSize) throws FileNotFoundException {
        this(tarFile, new MonitoredIOStreamCopier(bufferSize));
    }

    public Untar(File tarFile, MonitoredIOStreamCopier copier) throws FileNotFoundException {
        this.copier = copier;
        this.in = new TarArchiveInputStream((InputStream)new FileInputStream(tarFile));
        this.setOwner = Unix.isOperational() && Unix.getEuid() == 0;
    }

    public void extract(File rootDirectory) throws IOException {
        TarArchiveEntry entry;
        ArrayList<TarArchiveEntry> dirEntries = new ArrayList<TarArchiveEntry>();
        while ((entry = this.in.getNextTarEntry()) != null) {
            File entryFile = new File(rootDirectory, entry.getName());
            this.extractEntry(entry, entryFile, dirEntries);
        }
        ListIterator it = dirEntries.listIterator(dirEntries.size());
        while (it.hasPrevious()) {
            entry = (TarArchiveEntry)it.previous();
            this.setFileMetadata(new File(rootDirectory, entry.getName()), entry);
        }
    }

    public void extract(Map<String, File> locations) throws IOException {
        TarArchiveEntry entry;
        ArrayList<TarArchiveEntry> dirEntries = new ArrayList<TarArchiveEntry>();
        while ((entry = this.in.getNextTarEntry()) != null) {
            File entryFile = this.getEntryInLocation(entry, locations);
            if (entryFile == null) continue;
            this.extractEntry(entry, entryFile, dirEntries);
        }
        ListIterator it = dirEntries.listIterator(dirEntries.size());
        while (it.hasPrevious()) {
            entry = (TarArchiveEntry)it.previous();
            File entryFile = this.getEntryInLocation(entry, locations);
            this.setFileMetadata(entryFile, entry);
        }
    }

    private File getEntryInLocation(TarArchiveEntry entry, Map<String, File> locations) {
        String[] parts = entry.getName().split("/", 2);
        String head = parts[0];
        String tail = parts[1];
        File parent = locations.get(head);
        return parent == null ? null : new File(parent, tail);
    }

    private void extractEntry(TarArchiveEntry entry, File entryFile, List<TarArchiveEntry> dirEntries) throws FileNotFoundException, IOException {
        if (entry.isDirectory()) {
            dirEntries.add(entry);
            this.createDirectory(entryFile);
        } else if (entry.isLink()) {
            this.createHardLink(entryFile, entry);
        } else if (entry.isSymbolicLink()) {
            this.createSymbolicLink(entryFile, entry);
        } else if (entry.isFile()) {
            if (entry.isBlockDevice() || entry.isCharacterDevice() || entry.isFIFO() || entry.isGNULongLinkEntry() || entry.isGNULongNameEntry() || entry.isGNUSparse() || entry.isPaxHeader() || entry.isGlobalPaxHeader()) {
                return;
            }
            this.createParentDirectories(entryFile);
            this.extractFileContent(entryFile, entry);
            this.setFileMetadata(entryFile, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFileContent(File entryFile, TarArchiveEntry entry) throws FileNotFoundException, IOException {
        try (OutputStream out = this.createOutputStream(entryFile, entry);){
            this.copier.copy((InputStream)this.in, out);
        }
    }

    protected void createParentDirectories(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }

    protected void createSymbolicLink(File file, TarArchiveEntry entry) {
        if (Unix.isOperational()) {
            Unix.createSymbolicLink((String)entry.getLinkName(), (String)file.getPath());
        }
    }

    protected void createHardLink(File file, TarArchiveEntry entry) {
        if (Unix.isOperational()) {
            Unix.createHardLink((String)entry.getLinkName(), (String)file.getPath());
        }
    }

    protected void createDirectory(File directory) {
        directory.mkdirs();
    }

    protected void setFileMetadata(File entryFile, TarArchiveEntry entry) {
        if (Unix.isOperational()) {
            Unix.setAccessMode((String)entryFile.getPath(), (short)((short)entry.getMode()));
            if (this.setOwner) {
                Unix.setOwner((String)entryFile.getPath(), (int)entry.getUserId(), (int)entry.getGroupId());
            } else if (Unix.getUid() == entry.getUserId() && Unix.getGid() != entry.getGroupId()) {
                Unix.setOwner((String)entryFile.getPath(), (int)entry.getUserId(), (int)entry.getGroupId());
            }
        }
        entryFile.setLastModified(entry.getModTime().getTime());
    }

    protected OutputStream createOutputStream(File file, TarArchiveEntry entry) throws IOException {
        return new FileOutputStream(file);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.copier.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 2) {
            System.err.println("Untar <tarfile> <directory>");
            System.exit(1);
        }
        File tarFile = new File(args[0]);
        File directory = new File(args[1]);
        try (Untar untar = null;){
            MonitoredIOStreamCopier copier = new MonitoredIOStreamCopier(0x100000);
            copier.setLogger((ISimpleLogger)new ConsoleLogger());
            untar = new Untar(tarFile, copier);
            untar.extract(directory);
            untar.close();
        }
    }
}

