/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;

public class ImageHistogram {
    private static final int EIGHT_BIT_MASK = 255;
    private static final int FIVE_BIT_MASK = 31;
    private static final int SIX_BIT_MASK = 63;
    private final int[] redCounters;
    private final int[] greenCounters;
    private final int[] blueCounters;

    public static final ImageHistogram calculateHistogram(BufferedImage image) {
        int type = image.getType();
        DataBuffer dataBuffer = image.getData().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            DataBufferInt db = (DataBufferInt)dataBuffer;
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    return ImageHistogram.calculateHistogram(db, 16, 8, 0);
                }
                case 4: {
                    return ImageHistogram.calculateHistogram(db, 0, 8, 16);
                }
            }
            return ImageHistogram.calculateHistogramSlow(image);
        }
        if (dataBuffer instanceof DataBufferByte) {
            DataBufferByte db = (DataBufferByte)dataBuffer;
            switch (type) {
                case 5: {
                    return ImageHistogram.calculateHistogram(db, 3, 2, 1, 0);
                }
                case 6: 
                case 7: {
                    return ImageHistogram.calculateHistogram(db, 4, 3, 2, 1);
                }
                case 10: {
                    return ImageHistogram.calculateHistogram(db, 1, 0, 0, 0);
                }
            }
            return ImageHistogram.calculateHistogramSlow(image);
        }
        if (dataBuffer instanceof DataBufferUShort) {
            DataBufferUShort db = (DataBufferUShort)dataBuffer;
            switch (type) {
                case 9: {
                    return ImageHistogram.calculateHistogram(db, 10, 31, 5, 31, 0, 31);
                }
                case 8: {
                    return ImageHistogram.calculateHistogram(db, 11, 31, 5, 63, 0, 31);
                }
                case 11: {
                    return ImageHistogram.calculateHistogram(db, 8, 255, 8, 255, 8, 255);
                }
            }
            return ImageHistogram.calculateHistogramSlow(image);
        }
        return ImageHistogram.calculateHistogramSlow(image);
    }

    private static final ImageHistogram calculateHistogramSlow(BufferedImage image) {
        int[] rgbArray;
        int[] redCounters = new int[256];
        int[] greenCounters = new int[256];
        int[] blueCounters = new int[256];
        int width = image.getWidth();
        int height = image.getHeight();
        for (int pixel : rgbArray = image.getRGB(0, 0, width, height, null, 0, width)) {
            int n = pixel >> 16 & 0xFF;
            redCounters[n] = redCounters[n] + 1;
            int n2 = pixel >> 8 & 0xFF;
            greenCounters[n2] = greenCounters[n2] + 1;
            int n3 = pixel & 0xFF;
            blueCounters[n3] = blueCounters[n3] + 1;
        }
        return new ImageHistogram(redCounters, greenCounters, blueCounters);
    }

    private static final ImageHistogram calculateHistogram(DataBufferInt dataBuffer, int redShift, int greenShift, int blueShift) {
        int[] data = dataBuffer.getData();
        int[] redCounters = new int[256];
        int[] greenCounters = new int[256];
        int[] blueCounters = new int[256];
        for (int pixel : data) {
            int n = pixel >> redShift & 0xFF;
            redCounters[n] = redCounters[n] + 1;
            int n2 = pixel >> greenShift & 0xFF;
            greenCounters[n2] = greenCounters[n2] + 1;
            int n3 = pixel >> blueShift & 0xFF;
            blueCounters[n3] = blueCounters[n3] + 1;
        }
        return new ImageHistogram(redCounters, greenCounters, blueCounters);
    }

    private static final ImageHistogram calculateHistogram(DataBufferUShort dataBuffer, int redShift, int redMask, int greenShift, int greenMask, int blueShift, int blueMask) {
        short[] data = dataBuffer.getData();
        int[] redCounters = new int[256];
        int[] greenCounters = new int[256];
        int[] blueCounters = new int[256];
        for (short pixel : data) {
            int n = pixel >> redShift & redMask;
            redCounters[n] = redCounters[n] + 1;
            int n2 = pixel >> greenShift & greenMask;
            greenCounters[n2] = greenCounters[n2] + 1;
            int n3 = pixel >> blueShift & blueMask;
            blueCounters[n3] = blueCounters[n3] + 1;
        }
        return new ImageHistogram(redCounters, greenCounters, blueCounters);
    }

    private static final ImageHistogram calculateHistogram(DataBufferByte dataBuffer, int pixelSize, int redIndex, int greenIndex, int blueIndex) {
        byte[] data = dataBuffer.getData();
        int[] redCounters = new int[256];
        int[] greenCounters = new int[256];
        int[] blueCounters = new int[256];
        int n = data.length;
        for (int i = 0; i < n; i += pixelSize) {
            int n2 = data[i + redIndex] & 0xFF;
            redCounters[n2] = redCounters[n2] + 1;
            int n3 = data[i + greenIndex] & 0xFF;
            greenCounters[n3] = greenCounters[n3] + 1;
            int n4 = data[i + blueIndex] & 0xFF;
            blueCounters[n4] = blueCounters[n4] + 1;
        }
        return new ImageHistogram(redCounters, greenCounters, blueCounters);
    }

    private ImageHistogram(int[] redCounters, int[] greenCounters, int[] blueCounters) {
        this.redCounters = redCounters;
        this.greenCounters = greenCounters;
        this.blueCounters = blueCounters;
    }

    public int[] getRedHistogram() {
        return this.redCounters;
    }

    public int[] getGreenHistogram() {
        return this.greenCounters;
    }

    public int[] getBlueHistogram() {
        return this.blueCounters;
    }

    public String toString() {
        return this.renderAsASCIIChart(40, 10);
    }

    public String renderAsASCIIChart(int width, int height) {
        if (height < 5) {
            throw new IllegalArgumentException("Less than minimum height of 5: " + height);
        }
        ASCIICanvas canvas = new ASCIICanvas(width, height);
        if (this.isGray()) {
            if (width < 5) {
                throw new IllegalArgumentException("Less than minimum width of 5: " + width);
            }
            this.drawHistogram(canvas, 0, 0, width, height, this.redCounters, "gray");
        } else {
            if (width < 10) {
                throw new IllegalArgumentException("Less than minimum width of 10: " + width);
            }
            int w3 = (width + 2) / 3;
            this.drawHistogram(canvas, 0, 0, w3, height, this.redCounters, "red");
            this.drawHistogram(canvas, w3 - 1, 0, w3, height, this.greenCounters, "green");
            this.drawHistogram(canvas, 2 * w3 - 2, 0, w3, height, this.blueCounters, "blue");
        }
        return canvas.toString();
    }

    private void drawHistogram(ASCIICanvas canvas, int x, int y, int width, int height, int[] data, String title) {
        int i;
        canvas.drawHorizontalLine(x, y, width, '-');
        canvas.drawHorizontalLine(x, y + height - 2, width, '_');
        canvas.drawVerticalLine(x, y, height - 1, '|');
        canvas.drawVerticalLine(x + width - 1, y, height - 1, '|');
        canvas.setPixel(x, y, '+');
        canvas.setPixel(x + width - 1, y, '+');
        canvas.setPixel(x + width - 1, y + height - 2, '|');
        canvas.setPixel(x, y + height - 2, '|');
        canvas.drawCenteredText(x + width / 2, y + height - 1, title);
        int[] bins = new int[width - 2];
        int max = 0;
        for (i = 0; i < data.length; ++i) {
            int binIndex;
            int n = binIndex = i * bins.length / data.length;
            bins[n] = bins[n] + data[i];
            max = Math.max(max, bins[binIndex]);
        }
        for (i = 0; i < bins.length; ++i) {
            int barLength = bins[i] * (height - 2) / max;
            canvas.drawVerticalLine(x + 1 + i, y + height - 1 - barLength, barLength, '*');
        }
    }

    public boolean isGray() {
        for (int i = 0; i < this.redCounters.length; ++i) {
            int red = this.redCounters[i];
            int green = this.greenCounters[i];
            int blue = this.blueCounters[i];
            if (red == green && green == blue && blue == red) continue;
            return false;
        }
        return true;
    }

    private static final class ASCIICanvas {
        private int width;
        private int height;
        private char[] canvas;

        ASCIICanvas(int width, int height) {
            this.height = height;
            this.width = width + 1;
            this.canvas = new char[this.width * height];
            Arrays.fill(this.canvas, ' ');
        }

        void setPixel(int x, int y, char symbol) {
            this.canvas[y * this.width + x] = symbol;
        }

        void drawHorizontalLine(int x, int y, int length, char symbol) {
            int n = Math.min(x + length, this.width);
            for (int i = x; i < n; ++i) {
                this.canvas[y * this.width + i] = symbol;
            }
        }

        void drawVerticalLine(int x, int y, int length, char symbol) {
            int n = Math.min(y + length, this.height);
            for (int i = y; i < n; ++i) {
                this.canvas[i * this.width + x] = symbol;
            }
        }

        void drawCenteredText(int x, int y, String text) {
            for (int i = 0; i < text.length(); ++i) {
                this.canvas[y * this.width + x + i - text.length() / 2] = text.charAt(i);
            }
        }

        public String toString() {
            this.drawVerticalLine(this.width - 1, 0, this.height, '\n');
            return new String(this.canvas);
        }
    }
}

