/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.image;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

public class MixColors {
    private static final int MAX_COMPONENT_VALUE = 255;
    private static final float MAX_COMPONENT_VALUE_FLOAT = 255.0f;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MixColors.class);

    private static int getMaxComponent(int r, int g, int b) {
        int cmax;
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        return cmax;
    }

    private static float getMaxComponent(float r, float g, float b) {
        float cmax;
        float f = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        return cmax;
    }

    private static Color getColor(float red, float green, float blue) {
        float max = MixColors.getMaxComponent(red, green, blue);
        if (max > 255.0f) {
            float normFactor = 255.0f / max;
            red *= normFactor;
            green *= normFactor;
            blue *= normFactor;
        }
        return new Color(Math.round(red), Math.round(green), Math.round(blue));
    }

    private static Color getColor(float red, float green, float blue, int brightness) {
        float max = MixColors.getMaxComponent(red, green, blue);
        float normFactor = Math.min(255.0f, (float)brightness) / max;
        return new Color(Math.round(red *= normFactor), Math.round(green *= normFactor), Math.round(blue *= normFactor));
    }

    private static Color getColor(int red, int green, int blue) {
        int max = MixColors.getMaxComponent(red, green, blue);
        if (max > 255) {
            float normFactor = 255.0f / (float)max;
            red = Math.round((float)red * normFactor);
            green = Math.round((float)green * normFactor);
            blue = Math.round((float)blue * normFactor);
        }
        return new Color(red, green, blue);
    }

    private static Color getColor(int red, int green, int blue, int brightness) {
        int max = MixColors.getMaxComponent(red, green, blue);
        float normFactor = Math.min(255.0f, (float)brightness) / (float)max;
        red = Math.round((float)red * normFactor);
        green = Math.round((float)green * normFactor);
        blue = Math.round((float)blue * normFactor);
        return new Color(red, green, blue);
    }

    public static Color calcMixedColorQuadratic(Color[] colors, float[] intensities) {
        assert (colors.length == intensities.length) : "number of colors and intensities do not match";
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        int redLin = 0;
        int greenLin = 0;
        int blueLin = 0;
        for (int i = 0; i < colors.length; ++i) {
            float r = intensities[i] * (float)colors[i].getRed();
            float g = intensities[i] * (float)colors[i].getGreen();
            float b = intensities[i] * (float)colors[i].getBlue();
            redLin = (int)((float)redLin + r);
            greenLin = (int)((float)greenLin + g);
            blueLin = (int)((float)blueLin + b);
            float weight = MixColors.getMaxComponent(r, g, b);
            red += weight * r;
            green += weight * g;
            blue += weight * b;
        }
        return MixColors.getColor(red, green, blue, MixColors.getMaxComponent(redLin, greenLin, blueLin));
    }

    public static Color calcMixedColorQuadratic(Color[] colors) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int redLin = 0;
        int greenLin = 0;
        int blueLin = 0;
        for (int i = 0; i < colors.length; ++i) {
            int r = colors[i].getRed();
            int g = colors[i].getGreen();
            int b = colors[i].getBlue();
            redLin += r;
            greenLin += g;
            blueLin += b;
            int weight = MixColors.getMaxComponent(r, g, b);
            red += weight * r;
            green += weight * g;
            blue += weight * b;
        }
        return MixColors.getColor(red, green, blue, MixColors.getMaxComponent(redLin, greenLin, blueLin));
    }

    public static Color calcMixedColorLinear(Color[] colors, float[] intensities) {
        assert (colors.length == intensities.length) : "number of colors and intensities do not match";
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        for (int i = 0; i < colors.length; ++i) {
            float intensity = intensities[i];
            Color color = colors[i];
            float r = intensity * (float)color.getRed();
            float g = intensity * (float)color.getGreen();
            float b = intensity * (float)color.getBlue();
            red += r;
            green += g;
            blue += b;
        }
        return MixColors.getColor(red, green, blue);
    }

    public static Color calcMixedColorLinear(Color[] colors) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < colors.length; ++i) {
            int r = colors[i].getRed();
            int g = colors[i].getGreen();
            int b = colors[i].getBlue();
            red += r;
            green += g;
            blue += b;
        }
        return MixColors.getColor(red, green, blue);
    }

    public static BufferedImage mixImages(BufferedImage[] images, Color[] colors, boolean quadratic, float saturationEnhancementFactor) {
        assert (colors.length == images.length) : "number of colors and images do not match";
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ColorMergingAlgorithm mergeColorsAlgorithm = MixColors.createColorMergingAlgorithm(quadratic, saturationEnhancementFactor, images);
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        BufferedImage mixed = new BufferedImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color mixColor = mergeColorsAlgorithm.merge(colors, x, y, images);
                mixed.setRGB(x, y, mixColor.getRGB());
            }
        }
        operationLog.info((Object)("MIXING " + images.length + " images (" + width + "x" + height + ") took " + stopWatch));
        return mixed;
    }

    private static void fetchGrayscaleIntensities(float[] intensities, int x, int y, BufferedImage[] images) {
        for (int i = 0; i < images.length; ++i) {
            intensities[i] = images[i].getRaster().getSampleFloat(x, y, 0) / 255.0f;
        }
    }

    private static void fetchRGBIntensities(float[] intensities, int x, int y, BufferedImage[] images) {
        for (int i = 0; i < images.length; ++i) {
            int rgb = images[i].getRGB(x, y);
            Color color = new Color(rgb);
            int intensity = MixColors.getMaxComponent(color.getRed(), color.getGreen(), color.getBlue());
            intensities[i] = (float)intensity / 255.0f;
        }
    }

    private static Color saturate(float saturationEnhancementFactor, Color mixColor) {
        float[] hsb = Color.RGBtoHSB(mixColor.getRed(), mixColor.getGreen(), mixColor.getBlue(), null);
        return Color.getHSBColor(hsb[0], Math.min(1.0f, saturationEnhancementFactor * hsb[1]), hsb[2]);
    }

    private static ColorMergingAlgorithm createColorMergingAlgorithm(boolean quadratic, float saturationEnhancementFactor, BufferedImage[] images) {
        boolean isGrayscale = true;
        int numberOfImages = images.length;
        for (int i = 0; i < numberOfImages; ++i) {
            isGrayscale = isGrayscale && images[i].getColorModel().getNumColorComponents() == 1;
        }
        return MixColors.createColorMergingAlgorithm(quadratic, saturationEnhancementFactor, isGrayscale, numberOfImages);
    }

    private static ColorMergingAlgorithm createColorMergingAlgorithm(final boolean quadratic, final float saturationEnhancementFactor, final boolean isGrayscale, int numberOfImages) {
        final float[] intensities = new float[numberOfImages];
        return new ColorMergingAlgorithm(){

            @Override
            public Color merge(Color[] colors, int x, int y, BufferedImage[] images) {
                if (isGrayscale) {
                    MixColors.fetchGrayscaleIntensities(intensities, x, y, images);
                } else {
                    MixColors.fetchRGBIntensities(intensities, x, y, images);
                }
                Color color = quadratic ? MixColors.calcMixedColorQuadratic(colors, intensities) : MixColors.calcMixedColorLinear(colors, intensities);
                if (saturationEnhancementFactor > 0.0f) {
                    color = MixColors.saturate(saturationEnhancementFactor, color);
                }
                return color;
            }
        };
    }

    private static interface ColorMergingAlgorithm {
        public Color merge(Color[] var1, int var2, int var3, BufferedImage[] var4);
    }
}

