/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython;

import ch.systemsx.cisd.common.jython.IJythonInterpreter;
import ch.systemsx.cisd.common.jython.JythonScript;
import ch.systemsx.cisd.common.jython.JythonScriptBatch;
import ch.systemsx.cisd.common.jython.JythonScriptBatches;
import ch.systemsx.cisd.common.jython.JythonScriptLines;
import java.util.List;

public class JythonScriptSplitter {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int batchSize = 100;
    private IJythonInterpreter interpreter;

    public JythonScriptSplitter(IJythonInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public List<String> split(String scriptToSplit) {
        JythonScript script = new JythonScript(scriptToSplit);
        JythonScriptBatches batches = new JythonScriptBatches();
        JythonScriptBatch batch = new JythonScriptBatch();
        JythonScriptLines command = new JythonScriptLines();
        for (String line : script.getLines()) {
            if (command.getSize() > 0 && this.interpreter.isNextCommand(command.getLines())) {
                if (batch.getSize() > 0 && batch.getSize() + command.getSize() > this.getBatchSize()) {
                    batches.addBatch(batch);
                    batch = new JythonScriptBatch();
                }
                batch.addLines(command);
                command = new JythonScriptLines();
                command.addLine(line);
                continue;
            }
            command.addLine(line);
        }
        if (command.getSize() > 0) {
            batch.addLines(command);
        }
        if (batch.getSize() > 0) {
            batches.addBatch(batch);
        }
        return batches.getLines();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch size must be > 0");
        }
        this.batchSize = batchSize;
    }
}

