/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython.evaluator;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluatorFactory;
import ch.systemsx.cisd.common.jython.v25.Jython25EvaluatorFactory;
import ch.systemsx.cisd.common.jython.v27.Jython27EvaluatorFactory;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanInitializationException;

public class JythonEvaluatorSpringComponent {
    public static final String JYTHON_VERSION_KEY = "jython-version";
    @Private
    static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, JythonEvaluatorSpringComponent.class);

    public JythonEvaluatorSpringComponent(ExposablePropertyPlaceholderConfigurer propertyConfigurer) {
        this(propertyConfigurer.getResolvedProps());
    }

    public JythonEvaluatorSpringComponent(Properties resolvedProps) {
        String jythonVersion = resolvedProps.getProperty(JYTHON_VERSION_KEY);
        if ("2.7".equals(jythonVersion)) {
            Evaluator.setFactory(this.createJython27EvaluatorFactory());
        } else if ("2.5".equals(jythonVersion)) {
            Evaluator.setFactory(this.createJython25EvaluatorFactory());
        } else {
            String msg = "The jython-version property must be specified in service.properties - possible values are 2.5 and 2.7. Since openBIS version 16.04 recommended jython version is 2.7. There might be compatibility issues. For details see page 'Jython Version for Various Plugins' in openBIS documentation.";
            operationLog.error((Object)msg);
            throw new BeanInitializationException(msg);
        }
    }

    protected IJythonEvaluatorFactory createJython25EvaluatorFactory() {
        return new Jython25EvaluatorFactory();
    }

    protected IJythonEvaluatorFactory createJython27EvaluatorFactory() {
        return new Jython27EvaluatorFactory();
    }
}

