/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython.v25;

import ch.systemsx.cisd.common.jython.PythonInterpreter;
import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluator;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTraceback;

public final class Evaluator25
implements IJythonEvaluator {
    private final PythonInterpreter interpreter;
    private final String expression;
    private final PyCode compiledExpression;

    public static void initialize() {
        PySystemState.initialize();
    }

    public Evaluator25(String expression) throws EvaluatorException {
        this(expression, null, null);
    }

    public Evaluator25(String expression, Class<?> supportFunctionsOrNull, String initialScriptOrNull) throws EvaluatorException {
        this(expression, null, null, supportFunctionsOrNull, initialScriptOrNull, true);
    }

    public Evaluator25(String expression, String[] pythonPath, String scriptPath, Class<?> supportFunctionsOrNull, String initialScriptOrNull, boolean blockFileAccess) throws EvaluatorException {
        if (Evaluator.isMultiline(expression)) {
            throw new EvaluatorException("Expression '" + expression + "' contains line breaks");
        }
        this.interpreter = PythonInterpreter.createIsolatedPythonInterpreter();
        this.interpreter.addToPath(pythonPath);
        try {
            if (blockFileAccess) {
                this.interpreter.exec("def open():\n   pass");
            }
            if (supportFunctionsOrNull != null) {
                this.interpreter.exec("from " + supportFunctionsOrNull.getCanonicalName() + " import *");
            }
            if (initialScriptOrNull != null) {
                if (scriptPath != null) {
                    this.interpreter.exec("__file__='" + scriptPath + "'");
                }
                this.interpreter.exec(initialScriptOrNull);
            }
            this.expression = expression;
            this.compiledExpression = Evaluator25.doCompile(expression);
        }
        catch (PyException ex) {
            throw this.toEvaluatorException(ex);
        }
    }

    @Override
    public boolean hasFunction(String functionName) {
        PyObject pyObject = this.interpreter.get(functionName);
        return pyObject instanceof PyFunction;
    }

    @Override
    public Object evalFunction(String functionName, Object ... args) {
        try {
            PyObject pyObject = this.interpreter.get(functionName);
            if (pyObject == null) {
                throw new PyException((PyObject)new PyString("Unknown function"), functionName);
            }
            if (!(pyObject instanceof PyFunction)) {
                throw new PyException((PyObject)new PyString("Not a function"), "'" + functionName + "' is of type " + pyObject.getType().getName() + ".");
            }
            PyFunction func = (PyFunction)pyObject;
            PyObject[] pyArgs = new PyObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                pyArgs[i] = this.translateToPython(args[i]);
            }
            PyObject result = func.__call__(pyArgs);
            return this.translateToJava(result);
        }
        catch (PyException ex) {
            CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
            for (Object argument : args) {
                builder.append(argument);
            }
            throw Evaluator25.toEvaluatorException(ex, functionName + "(" + builder + ")");
        }
    }

    private PyObject translateToPython(Object javaObject) {
        if (javaObject instanceof String) {
            return new PyString((String)javaObject);
        }
        return Py.java2py((Object)javaObject);
    }

    private static PyCode doCompile(String expression) throws EvaluatorException {
        try {
            return Py.compile_flags((String)("__result__=(" + expression + ")"), (String)("expression: " + expression), (CompileMode)CompileMode.exec, (CompilerFlags)new CompilerFlags());
        }
        catch (PyException ex) {
            throw Evaluator25.toEvaluatorException(ex, expression);
        }
    }

    @Override
    public void set(String name, Object value) {
        this.interpreter.set(name, value);
    }

    @Override
    public Object get(String name) {
        return this.interpreter.get(name);
    }

    @Override
    public void delete(String name) {
        this.interpreter.getLocals().__delitem__(name);
    }

    @Override
    public boolean has(String name) {
        return ((PyStringMap)this.interpreter.getLocals()).has_key((PyObject)new PyString(name));
    }

    @Override
    public Evaluator.ReturnType getType() {
        this.doEval();
        PyObject obj = this.getInterpreterResult();
        if (obj instanceof PyBoolean) {
            return Evaluator.ReturnType.BOOLEAN;
        }
        if (obj instanceof PyInteger) {
            return Evaluator.ReturnType.INTEGER;
        }
        if (obj instanceof PyLong) {
            return Evaluator.ReturnType.BIGINT;
        }
        if (obj instanceof PyFloat) {
            return Evaluator.ReturnType.DOUBLE;
        }
        if (obj instanceof PyString) {
            return Evaluator.ReturnType.STRING;
        }
        return Evaluator.ReturnType.OTHER;
    }

    @Override
    public Object evalLegacy2_2() {
        this.doEval();
        PyObject obj = this.getInterpreterResult();
        Object result = this.translateToJavaLegacy(obj);
        if (!(result == null || result instanceof Long || result instanceof Double || result instanceof String)) {
            return result.toString();
        }
        return result;
    }

    @Override
    public Object eval() {
        this.doEval();
        return this.translateToJava(this.getInterpreterResult());
    }

    private Object translateToJavaLegacy(PyObject obj) {
        if (obj instanceof PyInteger) {
            return new Long(((PyInteger)obj).getValue());
        }
        if (obj instanceof PyLong) {
            return new Long(((PyLong)obj).getValue().longValue());
        }
        if (obj instanceof PyFloat) {
            return new Double(((PyFloat)obj).getValue());
        }
        if (obj instanceof PyNone) {
            return null;
        }
        if (obj instanceof PyList) {
            PyList pyList = (PyList)obj;
            PyObject[] array = pyList.getArray();
            ArrayList<Object> list = new ArrayList<Object>();
            int n = pyList.size();
            for (int i = 0; i < n; ++i) {
                list.add(this.translateToJavaLegacy(array[i]));
            }
            return list;
        }
        return this.translateToJava(obj);
    }

    private Object translateToJava(PyObject obj) {
        return obj == null ? null : obj.__tojava__(Object.class);
    }

    private PyObject getInterpreterResult() {
        return this.interpreter.get("__result__");
    }

    @Override
    public boolean evalToBoolean() throws EvaluatorException {
        this.doEval();
        try {
            return ((PyBoolean)this.getInterpreterResult()).getBooleanValue();
        }
        catch (ClassCastException ex) {
            Evaluator.ReturnType type = this.getType();
            throw new EvaluatorException("Expected a result of type " + (Object)((Object)Evaluator.ReturnType.BOOLEAN) + ", found " + (Object)((Object)type));
        }
    }

    @Override
    public int evalToInt() throws EvaluatorException {
        this.doEval();
        try {
            return ((PyInteger)this.getInterpreterResult()).getValue();
        }
        catch (ClassCastException ex) {
            Evaluator.ReturnType type = this.getType();
            throw new EvaluatorException("Expected a result of type " + (Object)((Object)Evaluator.ReturnType.INTEGER) + ", found " + (Object)((Object)type));
        }
    }

    @Override
    public BigInteger evalToBigInt() throws EvaluatorException {
        this.doEval();
        try {
            return ((PyLong)this.getInterpreterResult()).getValue();
        }
        catch (ClassCastException ex) {
            Evaluator.ReturnType type = this.getType();
            throw new EvaluatorException("Expected a result of type " + (Object)((Object)Evaluator.ReturnType.BIGINT) + ", found " + (Object)((Object)type));
        }
    }

    @Override
    public double evalToDouble() throws EvaluatorException {
        this.doEval();
        try {
            return ((PyFloat)this.getInterpreterResult()).getValue();
        }
        catch (ClassCastException ex) {
            Evaluator.ReturnType type = this.getType();
            throw new EvaluatorException("Expected a result of type " + (Object)((Object)Evaluator.ReturnType.DOUBLE) + ", found " + (Object)((Object)type));
        }
    }

    @Override
    public String evalAsStringLegacy2_2() throws EvaluatorException {
        Object result = this.evalLegacy2_2();
        return result == null ? null : result.toString();
    }

    @Override
    public String evalAsString() throws EvaluatorException {
        Object result = this.eval();
        return result == null ? null : result.toString();
    }

    private void doEval() throws EvaluatorException {
        try {
            this.interpreter.exec((PyObject)this.compiledExpression);
        }
        catch (PyException ex) {
            throw this.toEvaluatorException(ex);
        }
    }

    private EvaluatorException toEvaluatorException(PyException ex) {
        return Evaluator25.toEvaluatorException(ex, this.expression);
    }

    private static EvaluatorException toEvaluatorException(PyException ex, String expressionOrNull) {
        Throwable exception = ex;
        PyObject value = ex.value;
        Object object = value.__tojava__(Object.class);
        if (object instanceof Throwable) {
            exception = (Throwable)object;
        }
        String msg = Evaluator25.extractExceptionMessage(ex);
        if (expressionOrNull != null) {
            PyObject next;
            PyTraceback traceback = ex.traceback;
            while (traceback != null && (next = traceback.tb_next) instanceof PyTraceback) {
                traceback = (PyTraceback)next;
            }
            String details = traceback == null ? "" : "occurred in line " + traceback.tb_lineno + " of the script when ";
            msg = "Error " + details + "evaluating '" + expressionOrNull + "': " + msg;
        }
        return new EvaluatorException(msg, exception);
    }

    private static String extractExceptionMessage(PyException ex) {
        String[] description = StringUtils.split((String)ex.toString(), (char)'\n');
        return description[description.length - 1];
    }

    @Override
    public void releaseResources() {
        this.interpreter.releaseResources();
    }

    @Override
    public Collection<String> getGlobalVariables() {
        HashSet<String> results = new HashSet<String>();
        PyStringMap locals = (PyStringMap)this.interpreter.getLocals();
        for (Object key : locals.keys()) {
            results.add(key.toString());
        }
        return Collections.unmodifiableCollection(results);
    }
}

