/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython.v25;

import ch.systemsx.cisd.common.jython.IJythonFunction;
import ch.systemsx.cisd.common.jython.IJythonInterpreter;
import ch.systemsx.cisd.common.jython.IJythonInterpreterFactory;
import ch.systemsx.cisd.common.jython.IJythonObject;
import ch.systemsx.cisd.common.jython.PythonInterpreter;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyObject;

public class Jython25InterpreterFactory
implements IJythonInterpreterFactory {
    @Override
    public IJythonInterpreter createInterpreter() {
        return new Jython25Interpreter();
    }

    static class Jython25Interpreter
    implements IJythonInterpreter {
        private PythonInterpreter interpreter = PythonInterpreter.createIsolatedPythonInterpreter();

        @Override
        public void exec(String scriptString, String scriptFile) {
            this.interpreter.exec(scriptString, scriptFile);
        }

        @Override
        public void exec(String scriptString) {
            this.interpreter.exec(scriptString);
        }

        @Override
        public void set(String variableName, Object object) {
            this.interpreter.set(variableName, object);
        }

        @Override
        public void addToPath(String ... pythonPaths) {
            this.interpreter.addToPath(pythonPaths);
        }

        @Override
        public void releaseResources() {
            this.interpreter.releaseResources();
        }

        @Override
        public IJythonFunction tryJythonFunction(String name) {
            try {
                PyFunction function = (PyFunction)this.interpreter.get(name, PyFunction.class);
                return function == null ? null : new Jython25Function(function);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public boolean isNextCommand(String lines) {
            try {
                PyObject object = Py.compile_command_flags((String)lines, (String)"<input>", (CompileMode)CompileMode.single, (CompilerFlags)new CompilerFlags(), (boolean)true);
                return object != Py.None;
            }
            catch (PyException e) {
                return false;
            }
        }
    }

    static class Jython25Object
    implements IJythonObject {
        PyObject pyObject;

        public Jython25Object(PyObject object) {
            this.pyObject = object;
        }

        @Override
        public String getJythonType() {
            return this.pyObject.getClass().toString();
        }

        @Override
        public boolean isInteger() {
            return this.pyObject instanceof PyInteger;
        }

        @Override
        public int asInteger() {
            if (!this.isInteger()) {
                throw new IllegalStateException("Object is not integer");
            }
            return ((PyInteger)this.pyObject).asInt();
        }
    }

    static class Jython25Function
    implements IJythonFunction {
        PyFunction function;

        Jython25Function(PyFunction function) {
            this.function = function;
        }

        @Override
        public IJythonObject invoke(Object ... arguments) {
            PyObject[] pyArgs = new PyObject[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                pyArgs[i] = Py.java2py((Object)arguments[i]);
            }
            PyObject result = this.function.__call__(pyArgs);
            if (result == null) {
                return null;
            }
            return new Jython25Object(result);
        }

        @Override
        public int getArgumentCount() {
            if (this.function.func_code instanceof PyBaseCode) {
                return ((PyBaseCode)this.function.func_code).co_argcount;
            }
            return -1;
        }
    }
}

