/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython.v27;

import ch.systemsx.cisd.common.jython.IJythonFunction;
import ch.systemsx.cisd.common.jython.IJythonInterpreter;
import ch.systemsx.cisd.common.jython.IJythonInterpreterFactory;
import ch.systemsx.cisd.common.jython.IJythonObject;
import ch.systemsx.cisd.common.jython.v27.JythonUtils;
import ch.systemsx.cisd.common.jython.v27.PythonInterpreter27;
import org.python27.core.CompileMode;
import org.python27.core.CompilerFlags;
import org.python27.core.Py;
import org.python27.core.PyBaseCode;
import org.python27.core.PyException;
import org.python27.core.PyFunction;
import org.python27.core.PyInteger;
import org.python27.core.PyObject;

public class Jython27InterpreterFactory
implements IJythonInterpreterFactory {
    @Override
    public IJythonInterpreter createInterpreter() {
        return new Jython27Interpreter();
    }

    static class Jython27Interpreter
    implements IJythonInterpreter {
        private PythonInterpreter27 interpreter = PythonInterpreter27.createIsolatedPythonInterpreter();

        @Override
        public void exec(String scriptString, String scriptFile) {
            this.interpreter.exec(scriptString, scriptFile);
        }

        @Override
        public void exec(String scriptString) {
            this.interpreter.exec(scriptString);
        }

        @Override
        public void set(String variableName, Object object) {
            this.interpreter.set(variableName, object);
        }

        @Override
        public void addToPath(String ... pythonPaths) {
            this.interpreter.addToPath(pythonPaths);
        }

        @Override
        public void releaseResources() {
            this.interpreter.releaseResources();
        }

        @Override
        public IJythonFunction tryJythonFunction(String name) {
            PyFunction function = JythonUtils.tryJythonFunction(this.interpreter, name);
            if (function == null) {
                return null;
            }
            return new Jython27Function(function);
        }

        @Override
        public boolean isNextCommand(String lines) {
            try {
                PyObject object = Py.compile_command_flags((String)lines, (String)"<input>", (CompileMode)CompileMode.single, (CompilerFlags)new CompilerFlags(), (boolean)true);
                return object != Py.None;
            }
            catch (PyException e) {
                return false;
            }
        }
    }

    static class Jython27Object
    implements IJythonObject {
        PyObject pyObject;

        public Jython27Object(PyObject object) {
            this.pyObject = object;
        }

        @Override
        public String getJythonType() {
            return this.pyObject.getClass().toString();
        }

        @Override
        public boolean isInteger() {
            return this.pyObject instanceof PyInteger;
        }

        @Override
        public int asInteger() {
            if (!this.isInteger()) {
                throw new IllegalStateException("Object is not integer");
            }
            return ((PyInteger)this.pyObject).asInt();
        }
    }

    static class Jython27Function
    implements IJythonFunction {
        PyFunction function;

        Jython27Function(PyFunction function) {
            this.function = function;
        }

        @Override
        public IJythonObject invoke(Object ... arguments) {
            PyObject result = JythonUtils.invokeFunction(this.function, arguments);
            if (result == null) {
                return null;
            }
            return new Jython27Object(result);
        }

        @Override
        public int getArgumentCount() {
            if (this.function.getFuncCode() instanceof PyBaseCode) {
                return ((PyBaseCode)this.function.getFuncCode()).co_argcount;
            }
            return -1;
        }
    }
}

