/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.monitoring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.monitoring.JMXMemoryMonitor;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public class JMXMemoryMonitorSpringBean
implements InitializingBean {
    private static final String MEMORY_MONITORING_INTERVAL_PROP = "memorymonitor-monitoring-interval";
    private static final String MEMORY_MONITORING_LOG_INTERVAL_PROP = "memorymonitor-log-interval";
    private static final String MEMORY_MONITORING_HIGH_WATERMARK_PERCENT_PROP = "memorymonitor-high-watermark-percent";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, JMXMemoryMonitorSpringBean.class);
    private static final long MILLISECONDS = 1000L;
    private static final long DEFAULT_MONITORING_INTERVALL_MILLIS = 60000L;
    private static final long DEFAULT_LOG_INTERVAL_MILLIS = 3600000L;
    private static final int DEFAULT_MEMORY_HIGH_WATERMARK_PERCENT = 90;
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;

    public void afterPropertiesSet() throws Exception {
        int memoryHighWatermarkPercent;
        Properties props = this.configurer.getResolvedProps();
        long monitoringIntervalMillis = props.getProperty(MEMORY_MONITORING_INTERVAL_PROP) == null ? 60000L : (long)Integer.parseInt(props.getProperty(MEMORY_MONITORING_INTERVAL_PROP)) * 1000L;
        long logIntervalMillis = props.getProperty(MEMORY_MONITORING_LOG_INTERVAL_PROP) == null ? 3600000L : (long)Integer.parseInt(props.getProperty(MEMORY_MONITORING_LOG_INTERVAL_PROP)) * 1000L;
        int n = memoryHighWatermarkPercent = props.getProperty(MEMORY_MONITORING_HIGH_WATERMARK_PERCENT_PROP) == null ? 90 : Integer.parseInt(props.getProperty(MEMORY_MONITORING_HIGH_WATERMARK_PERCENT_PROP));
        if (monitoringIntervalMillis > 0L) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("Starting JMX Memory monitor with parameters %s=%s, %s=%s, %s=%s", MEMORY_MONITORING_INTERVAL_PROP, monitoringIntervalMillis / 1000L, MEMORY_MONITORING_LOG_INTERVAL_PROP, logIntervalMillis < 0L ? "DISABLED" : Long.valueOf(logIntervalMillis / 1000L), MEMORY_MONITORING_HIGH_WATERMARK_PERCENT_PROP, memoryHighWatermarkPercent >= 100 ? "DISABLED" : Integer.valueOf(memoryHighWatermarkPercent)));
            }
            JMXMemoryMonitor.startMonitor(monitoringIntervalMillis, logIntervalMillis, memoryHighWatermarkPercent);
        }
    }
}

